## BEDR

This is the official pytorch implementation of From Deterministic to Probabilistic World: Balancing Enhanced Doubly Robust Learning for Debiased Recommendation.


## Run the code

- For Coat, please run the file:


```python
coat.ipynb
```


- For Yahoo! R3, please run the file:

```python
yahoo.ipynb
```


- For KuaiRec, please run the file:


```python
kuai.ipynb 
```


The code runs well at python 3.8.10. The required packages are as follows:
-   pytorch == 2.0.0
-   numpy == 1.24.2 
-   scipy == 1.10.1
-   pandas == 2.0.0


## Acknowledgments
We follow the previous study, which is shown below:  
- Matrix factorization techniques for recommender systems.  
- Probabilistic matrix factorization.
- Recommendations as treatments: Debiasing learning and evaluation.  
- Doubly robust estimator for ranking metrics with post-click conversions.  
- Doubly robust joint learning for recommendation on data missing not at random. 
- Information theoretic counterfactual learning from missing-not-at-random feedback. 
- Tdr-cl: Targeted doubly robust collaborative learning for debiased recommendations.
- Stabledr: Stabilized doubly robust learning for recommendation on data missing not at random.
