import matplotlib.pyplot as plt
import matplotlib

plt.figure(figsize=(6, 5))
data = [99.6, 99.6, 0, 98.3, 98.6, 99.6]
labels = ["SimpleNet", "PNI", "", "ViTAD", "MambaAD", ""]
colors = ["royalblue", "royalblue", 'black', 'orange', 'orange', 'springgreen']

ax = plt.gca()
ax.set_ylim(97, 100)
plt.tick_params(left=True, right=False, labelleft=True,
                labelbottom=True, bottom=False)

plt.bar(range(len(data)), data, color=colors, width=0.7)
plt.xticks(range(len(data)), labels)
plt.ylabel("image AUROC")
plt.show()

plt.figure(figsize=(6, 5))
data = [98.1, 97.8, 0, 95.5, 94.3, 98.7]
labels = ["EfficientAD", "RealNet", "", "ReContrast", "MambaAD", ""]
colors = ["royalblue", "royalblue", 'black', 'orange', 'orange', 'springgreen']

ax = plt.gca()
ax.set_ylim(92, 100)
plt.tick_params(left=True, right=False, labelleft=True,
                labelbottom=True, bottom=False)

plt.bar(range(len(data)), data, color=colors, width=0.7)
plt.xticks(range(len(data)), labels)
plt.ylabel("image AUROC")
plt.show()

plt.figure(figsize=(6, 5))
data = [89.4, 88.5, 0, 86.4, 86.3, 89.3]
labels = ["PatchCore", "SimpleNet", "", "ReContrast", "MambaAD", ""]
colors = ["royalblue", "royalblue", 'black', 'orange', 'orange', 'springgreen']

ax = plt.gca()
ax.set_ylim(81, 91)
plt.tick_params(left=True, right=False, labelleft=True,
                labelbottom=True, bottom=False)

plt.bar(range(len(data)), data, color=colors, width=0.7)
plt.xticks(range(len(data)), labels)
plt.ylabel("image AUROC")
plt.show()
