from typing import Tuple
import functools
import jax
import jax.numpy as jnp
from flax.training.train_state import TrainState

from src.common import InfoDict, Params, Batch
from src.agents.td3_derl.rnd_states import RNDTrainState


@functools.partial(jax.jit)
def update(
    actor: TrainState,
    critic: TrainState,
    rnd: RNDTrainState,
    batch: Batch,
    rnd_coeff: float = 0.0,
) -> Tuple[TrainState, InfoDict]:

    def actor_loss_fn(actor_params: Params) -> Tuple[jax.Array, InfoDict]:

        pi_actions = actor.apply_fn(actor_params, batch.observations)
        q, _ = critic.apply_fn(critic.params, batch.observations, pi_actions)
        # pred, target = rnd.apply_fn(rnd.params, batch.observations, pi_actions)
        # rnd_bonus = jnp.sum((pred - target) ** 2, axis=1)

        # actor_loss = (-q - rnd_coeff * rnd_bonus).mean()
        actor_loss = -q.mean()
        info = {
            "actor_loss": actor_loss,
            # "actor_rnd_bonus": rnd_bonus.mean(),
        }

        return actor_loss, info

    grads, info = jax.grad(actor_loss_fn, has_aux=True)(actor.params)
    new_actor = actor.apply_gradients(grads=grads)

    return new_actor, info
