from diffusers import StableDiffusionPipeline
import torch
import os
from transformers import CLIPTextModel, CLIPTokenizer, CLIPImageProcessor
import clip
from PIL import Image
from diffusers import AutoencoderKL, DDIMScheduler, StableDiffusionPipeline, UNet2DConditionModel


model_id = "selective_amnesia_checkpoints/brad_pitt_middle_aged_man_diffusers"
pipe = StableDiffusionPipeline.from_pretrained(model_id)

prompts = ["a photo of Angelina Jolie in the style of Van Gogh", "a photo of Brad Pitt in the style of Van Gogh"]
pipe = pipe.to("cuda")

output_dir = "diffusers_test/brad_pitt_middle_aged_man_diffusers"

for prompt in prompts:

    print(model_id)
    os.makedirs(output_dir, exist_ok=True)

    for i in range(10):
        image = pipe(prompt, num_inference_steps=50, guidance_scale=7.5).images[0]

        os.makedirs(output_dir, exist_ok=True)
        image.save(os.path.join(output_dir, f"{prompt}_{i}.png"))




