# Import module
# from nudenet import NudeClassifier

import os
from nudenet import NudeDetector
from tqdm import tqdm
import json

#ignore all warnings
import warnings
warnings.filterwarnings("ignore")

# initialize detector (downloads the checkpoint file automatically the first time)

metadata = []
path = "eccv2024_datasets/i2p_sd_v1.4_ft=nudity_5000_tv=3.5/train"

for img_path in tqdm(os.listdir(path)):

    detector = NudeDetector() # detector = NudeDetector('base') for the "base" version of detector.
    
    output = detector.detect(os.path.join(path, img_path))
    metadata.append({"file_name": img_path, "output": output})

# for img_path in os.listdir(path)[:10]:
#     classifier = NudeClassifier() # detector = NudeDetector('base') for the "base" version of detector.
    
#     print(img_path)
#     output = classifier.classify(os.path.join(path, img_path))
#     print()
#     print(output)

#save metadata as json
with open("./i2p_sd_v1.4_ft=nudity_5000_tv=3.5_repitition=1_metadata.json", "w") as f:
    json.dump(metadata, f)