#!/usr/bin/env bash
set -xeuo pipefail

project_name='GRM'
exp_name='32B-Self-Reward'
WORKING_DIR=/personal/code/feat_hbsr
cd ${WORKING_DIR}

ENABLE_THINKING=True

TRAIN_FILE=${TRAIN_FILE:-"hb_verl_train.parquet"}
TEST_FILE=${TEST_FILE:-"hb_verl_test.parquet"}
MODEL_PATH=${MODEL_PATH:-"ckpts/Qwen3-32B"}
CKPTS_DIR=${CKPTS_DIR:-"ckpts/${project_name}/${exp_name}"}

export RAY_EXPERIMENTAL_NOSET_CUDA_VISIBLE_DEVICES=0
export CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7
export TENSORBOARD_DIR=/home/admin/logs/tfevent/${exp_name}

adv_estimator=grpo

use_kl_in_reward=False
kl_coef=0.0
use_kl_loss=False
kl_loss_coef=0.0

clip_ratio_low=0.2
clip_ratio_high=0.28

max_prompt_length=$((1024 * 2))
max_response_length=$((1024 * 6))
max_model_length=$(( (max_prompt_length + max_response_length) * 2 ))

loss_agg_mode="token-mean"

train_prompt_bsz=32
n_resp_per_prompt=4
train_prompt_mini_bsz=32

# Ray
RAY_ADDRESS=${RAY_ADDRESS:-"http://localhost:8265"}
WORKING_DIR=${WORKING_DIR:-"/personal/code/feat_hbsr"}
RUNTIME_ENV=${RUNTIME_ENV:-"${WORKING_DIR}/verl/trainer/runtime_env.yaml"}
NNODES=${NNODES:-4}

# Algorithm
temperature=1.0
top_p=1.0
top_k=-1 # 0 for HF rollout, -1 for vLLM rollout

# For val and reward
if [ "${ENABLE_THINKING}" = "True" ]; then
    val_temperature=0.6
    val_top_p=0.95
else
    val_temperature=0.7
    val_top_p=0.8
fi

val_top_k=20

# Performance Related Parameter
offload=True
gen_tp=4
train_tp=4
train_pp=2

python3 -m verl.trainer.main_ppo \
    --config-path=config \
    --config-name='ppo_megatron_trainer.yaml' \
    data.train_files="${TRAIN_FILE}" \
    data.val_files="${TEST_FILE}" \
    data.truncation='left' \
    data.max_prompt_length=${max_prompt_length} \
    data.max_response_length=${max_response_length} \
    data.train_batch_size=${train_prompt_bsz} \
    actor_rollout_ref.rollout.n=${n_resp_per_prompt} \
    algorithm.adv_estimator=${adv_estimator} \
    algorithm.use_kl_in_reward=${use_kl_in_reward} \
    algorithm.kl_ctrl.kl_coef=${kl_coef} \
    actor_rollout_ref.actor.use_kl_loss=${use_kl_loss} \
    actor_rollout_ref.actor.kl_loss_coef=${kl_loss_coef} \
    actor_rollout_ref.actor.clip_ratio_low=${clip_ratio_low} \
    actor_rollout_ref.actor.clip_ratio_high=${clip_ratio_high} \
    actor_rollout_ref.actor.clip_ratio_c=10.0 \
    actor_rollout_ref.actor.ppo_micro_batch_size_per_gpu=2 \
    actor_rollout_ref.ref.log_prob_micro_batch_size_per_gpu=2 \
    actor_rollout_ref.rollout.name=vllm \
    actor_rollout_ref.rollout.engine_kwargs.vllm.disable_mm_preprocessor_cache=False \
    actor_rollout_ref.rollout.gpu_memory_utilization=0.5 \
    actor_rollout_ref.rollout.log_prob_micro_batch_size_per_gpu=2 \
    actor_rollout_ref.model.path="${MODEL_PATH}" \
    +actor_rollout_ref.model.enable_gradient_checkpointing=True \
    actor_rollout_ref.actor.optim.lr=1e-6 \
    actor_rollout_ref.actor.optim.lr_warmup_steps=10 \
    actor_rollout_ref.actor.optim.weight_decay=0.1 \
    actor_rollout_ref.actor.ppo_mini_batch_size=${train_prompt_mini_bsz} \
    actor_rollout_ref.actor.megatron.param_offload=${offload} \
    actor_rollout_ref.actor.megatron.optimizer_offload=${offload} \
    actor_rollout_ref.actor.megatron.grad_offload=${offload} \
    +actor_rollout_ref.actor.megatron.override_transformer_config.recompute_method=uniform \
    +actor_rollout_ref.actor.megatron.override_transformer_config.recompute_granularity=full \
    +actor_rollout_ref.actor.megatron.override_transformer_config.recompute_num_layers=1 \
    actor_rollout_ref.actor.megatron.pipeline_model_parallel_size=${train_pp} \
    actor_rollout_ref.actor.megatron.tensor_model_parallel_size=${train_tp} \
    actor_rollout_ref.actor.megatron.use_mbridge=True \
    actor_rollout_ref.actor.entropy_coeff=0 \
    actor_rollout_ref.actor.optim.clip_grad=1.0 \
    actor_rollout_ref.actor.loss_agg_mode=${loss_agg_mode} \
    actor_rollout_ref.rollout.tensor_model_parallel_size=${gen_tp} \
    actor_rollout_ref.rollout.enable_chunked_prefill=True \
    actor_rollout_ref.rollout.max_num_batched_tokens=${max_model_length} \
    actor_rollout_ref.rollout.max_model_len=${max_model_length} \
    actor_rollout_ref.rollout.temperature=${temperature} \
    actor_rollout_ref.rollout.top_p=${top_p} \
    actor_rollout_ref.rollout.top_k=${top_k} \
    actor_rollout_ref.rollout.val_kwargs.temperature=${val_temperature} \
    actor_rollout_ref.rollout.val_kwargs.top_p=${val_top_p} \
    actor_rollout_ref.rollout.val_kwargs.top_k=${val_top_k} \
    actor_rollout_ref.rollout.val_kwargs.do_sample=True \
    actor_rollout_ref.rollout.val_kwargs.n=1 \
    actor_rollout_ref.ref.megatron.pipeline_model_parallel_size=${train_pp} \
    actor_rollout_ref.ref.megatron.tensor_model_parallel_size=${train_tp} \
    actor_rollout_ref.ref.megatron.param_offload=${offload} \
    reward_model.reward_manager=generative \
    +reward_model.reward_kwargs.gen_rm.api_base="" \
    +reward_model.reward_kwargs.gen_rm.api_key="EMPTY" \
    +reward_model.reward_kwargs.gen_rm.model_name=Qwen3-32B \
    +reward_model.reward_kwargs.gen_rm.temperature=${val_temperature} \
    +reward_model.reward_kwargs.gen_rm.top_p=${val_top_p} \
    +reward_model.reward_kwargs.gen_rm.top_k=${val_top_k} \
    +reward_model.reward_kwargs.gen_rm.enable_thinking=${ENABLE_THINKING} \
    +reward_model.reward_kwargs.gen_rm.default_score=0 \
    +reward_model.reward_kwargs.gen_rm.max_concurrent=100 \
    +reward_model.reward_kwargs.gen_rm.logging_dir="logs" \
    +reward_model.reward_kwargs.gen_rm.api_timeout=60 \
    +reward_model.reward_kwargs.gen_rm.max_tokens=4096 \
    +reward_model.reward_kwargs.gen_rm.max_retries=3 \
    +reward_model.reward_kwargs.gen_rm.task=healthbench \
    trainer.logger=['console','tensorboard'] \
    trainer.project_name="${project_name}" \
    trainer.experiment_name="${exp_name}" \
    trainer.n_gpus_per_node=8 \
    trainer.nnodes="${NNODES}" \
    trainer.val_before_train=False \
    trainer.test_freq=50 \
    trainer.save_freq=50 \
    trainer.total_epochs=10 \
    trainer.default_local_dir="${CKPTS_DIR}" \
    trainer.resume_mode=auto \
    trainer.log_val_generations=10
