import os

def get_asset_directory_path():
    return os.path.dirname(os.path.abspath(__file__))

def get_asset_path(asset_name):
    path = os.path.join(get_asset_directory_path(), asset_name)
    if not os.path.exists(path):
        raise FileNotFoundError(f"Asset {asset_name} not found in {get_asset_directory_path()}")
    return path
