import numpy as np
import pybullet as pb

from .sim_object import *
from .region import *


def in_region(region: Region, object: RigidObject) -> bool:
    """Checks if the object is within the region.
    """
    return region.in_region(object)


def is_collision(object1: RigidObject, object2: RigidObject) -> bool:
    """Checks if the object is colliding with another object.
    """
    return object1.is_collision(object2)


def place_occupied(
    object: RigidObject,
    position: np.ndarray,
    orientation: np.ndarray,
) -> bool:
    """Checks if the place is occupied by another object.
    """
    original_position = object.get_position()
    original_orientation = object.get_orientation()

    object.set_pose(position, orientation)
    pb.performCollisionDetection()
    occupied = object.is_collision()
    object.set_pose(original_position, original_orientation)
    return occupied
