#!/bin/bash

# gdown is required to download the asset from Google Drive

# check gdown is installed

set -exu
if ! command -v gdown &> /dev/null
then
    echo "gdown could not be found, please install it first."
    exit
fi

# check if the asset is already downloaded
CURRENT_DIR=$(pwd)
ASSET_GDRIVE_ID=1hnSMBlKBLPsGPapxq3BYVP9iiMmpffWk
DATASET_GDRIVE_ID=1VGMn--6gTAXHKsnauvHndor8LpA0-acj

gdown --id $ASSET_GDRIVE_ID -O $CURRENT_DIR/asset.zip
gdown --id $DATASET_GDRIVE_ID -O $CURRENT_DIR/dataset.zip

# unzip the asset
unzip -o $CURRENT_DIR/asset.zip -d $CURRENT_DIR
mkdir -p $CURRENT_DIR/temp
unzip -o $CURRENT_DIR/dataset.zip -d $CURRENT_DIR/temp
mv $CURRENT_DIR/temp/dataset $CURRENT_DIR/object_dataset

# remove the zip files
# rm $CURRENT_DIR/asset.zip
# rm $CURRENT_DIR/dataset.zip

# CCD evaluation dataset
mkdir -p $CURRENT_DIR/temp/swept_volume_dataset
gdown --id 1JJjtOuZIRK6sn6obmy7LediY7zP-VgSM -O $CURRENT_DIR/temp/swept_volume_dataset/2025_04_01_13_13_40.pkl
gdown --id 1iddcFboOHdLiXCIHh2KaVp-v_9mMC_gY -O $CURRENT_DIR/temp/swept_volume_dataset/2025_04_02_07_18_51.pkl
