# setup.py

from setuptools import setup, Extension
import sys
import pybind11
from pybind11.setup_helpers import Pybind11Extension, build_ext

ext_modules = [
    Pybind11Extension(
        "astar_module",
        ["astar.cpp"],
        include_dirs=[pybind11.get_include()],
        language='c++',
    ),
]

setup(
    name="astar_module",
    version="0.1",
    description="A* algorithm in C++ with Python bindings",
    ext_modules=ext_modules,
    cmdclass={"build_ext": build_ext},
)