from typing import Tuple

import numpy as np

import pybullet as pb


def change_frame(
    local_pose: Tuple[np.ndarray, np.ndarray],
    target_frame: Tuple[np.ndarray, np.ndarray],
    ref_frame: Tuple[np.ndarray,
                     np.ndarray] = (np.array([0, 0, 0]), np.array([0, 0, 0,
                                                                   1])),
):
    """Changes the frame of a pose from the local frame to the target frame.
    """
    world_pose = pb.multiplyTransforms(ref_frame[0], ref_frame[1],
                                       local_pose[0], local_pose[1])
    target_frame_inverse = pb.invertTransform(target_frame[0], target_frame[1])
    new_local_pose = pb.multiplyTransforms(target_frame_inverse[0],
                                           target_frame_inverse[1],
                                           world_pose[0], world_pose[1])
    return new_local_pose
