# NeuralSVCD

## Install
```sh
git clone https://github.com/neuralsvcd/PointObjRep.git
./scripts/download_asset.sh
```

## Experiment

### CCD evaluation

```sh
./scripts/evaluate_swept_volume.sh
```

### Motion Planning

#### Multiple Dish Insertion

```sh
python evaluation/eval_motion_planner.py --config evaluation/mp_config/dish_multiple.yml --ccd_type ours
python evaluation/eval_motion_planner.py --config evaluation/mp_config/dish_multiple.yml --ccd_type curobo --curobo_moving_obj_npnts 50
python evaluation/eval_motion_planner.py --config evaluation/mp_config/dish_multiple.yml --ccd_type curobo --curobo_moving_obj_npnts 2000
python evaluation/eval_motion_planner.py --config evaluation/mp_config/dish_multiple_stamp.yml --ccd_type stamp
```

#### Bimanual Insertion

```sh
python evaluation/eval_motion_planner.py --config evaluation/mp_config/bimanual_hard.yml --ccd_type ours
python evaluation/eval_motion_planner.py --config evaluation/mp_config/bimanual_hard.yml --ccd_type curobo --curobo_moving_obj_npnts 100
python evaluation/eval_motion_planner.py --config evaluation/mp_config/bimanual_hard.yml --ccd_type curobo --curobo_moving_obj_npnts 1200
python evaluation/eval_motion_planner.py --config evaluation/mp_config/bimanual_hard_stamp.yml --ccd_type stamp
```

#### Mining Site Navigation

```sh
python evaluation/eval_motion_planner.py --config evaluation/mp_config/construction_site_hard.yml --ccd_type ours
python evaluation/eval_motion_planner.py --config evaluation/mp_config/construction_site_hard.yml --ccd_type curobo --curobo_moving_obj_npnts 50
python evaluation/eval_motion_planner.py --config evaluation/mp_config/construction_site_hard.yml --ccd_type curobo --curobo_moving_obj_npnts 400
python evaluation/eval_motion_planner.py --config evaluation/mp_config/construction_site_hard_stamp.yml --ccd_type stamp
```
