#!/bin/bash
seed=0

run_evaluation() {
    local data_path="$1"
    local result_dir="$2"

    echo "Running evaluations with data_path: $data_path"
    echo "Storing results in: $result_dir"
    echo "Seed is: $seed"

    for evaluation_type in trajopt_ccd trajopt_stamp trajopt_ccd ours_global_stamp ours_ccd ours_stamp curobo_ccd
    do
        echo $evaluation_type
        python evaluation/eval_swept_volume.py evaluate \
            --data_path "$data_path" \
            --result_dir "$result_dir" \
            --evaluation_type "$evaluation_type" \
            --trials 300 \
            --seed "$seed"
    done
}

data_path=temp/swept_volume_dataset/2025_04_02_07_18_51.pkl
result_dir=temp/swept_volume_dataset/result/id/
run_evaluation "$data_path" "$result_dir"

data_path=temp/swept_volume_dataset/2025_04_01_13_13_40.pkl
result_dir=temp/swept_volume_dataset/result/ood/
run_evaluation "$data_path" "$result_dir"

python evaluation/eval_swept_volume.py plot-multiple \
    --result_dirs temp/swept_volume_dataset/result/id/ \
    --subtitles ID \
    --result_dirs temp/swept_volume_dataset/result/ood/ \
    --subtitles OOD \
    --xlabel "time" \
    --ylabel accuracy \
    --draw_pareto
