#imports
import numpy as np
import os
import concurrent.futures as cf

from helper_functions import *
from experiment import threaded_experiment

K = [8, 16, 32, 64]
distributions = ['halfnormal', 'exponential', 'lomax']
folder = "thread_experiment2_results"
reps = 10000

def run_experiment(distribution, k):
    # print(f"Running experiment for distribution={distribution}, k={k}")
    path = f"{folder}/{distribution}/{k}"
    os.makedirs(path, exist_ok=True)

    L = int(np.ceil(np.log2(k))) + 2

    result = threaded_experiment(
        repetitions=reps, dimension=k,
        num_clusters=k, distribution=distribution,
        candidates=np.tile(1, k)
    )
    np.save(f"{path}/non-greedy_results.npy", result)

    result_greedy = threaded_experiment(
        repetitions=reps, dimension=k,
        num_clusters=k, distribution=distribution,
        candidates=np.tile(L, k)
    )
    np.save(f"{path}/greedy_results.npy", result_greedy)
    return distribution, k

if __name__ == '__main__':
    tasks = [(distribution, k) for distribution in distributions for k in K]

    with cf.ProcessPoolExecutor() as executor:
        futures = [executor.submit(run_experiment, d, k) for d, k in tasks]
        for future in cf.as_completed(futures):
            distribution, k = future.result()
            print(f'Finished {distribution},{k}')