# ReCon: Region-Controllable Data Augmentation with Rectification and Alignment for Object Detection

This is the official repository of **ReCon: Region-Controllable Data Augmentation with Rectification and Alignment for Object Detection**.

---

## 📌 1. Highlights

<!-- ![main figure](figure/intro.png) -->

> **Abstract:** *The scale and quality of datasets are crucial for training robust perception models. However, obtaining large-scale annotated data is both costly and time-consuming. Generative models have emerged as a powerful tool for data augmentation by synthesizing samples that adhere to desired distributions. However, current generative approaches often rely on complex post-processing or extensive fine-tuning on massive datasets to achieve satisfactory results, and they remain prone to content–position mismatches and semantic leakage. To overcome these limitations, we introduce ReCon, a novel augmentation framework that enhances the capacity of structure-controllable generative models for object detection. ReCon integrates region-guided rectification into the diffusion sampling process, using feedback from a pre-trained perception model to rectify misgenerated regions within diffusion sampling process. We further propose region-aligned cross-attention to enforce spatial–semantic alignment between image regions and their textual cues, thereby improving both semantic consistency and overall image fidelity. Extensive experiments demonstrate that ReCon substantially improves the quality and trainability of generated data, achieving consistent performance gains across various datasets, backbone architectures, and data scales.*

---

## 🚀 2. Main Contributions

1. We propose **ReCon**, a novel region-controllable data augmentation method that enhances the regional control capabilities of existing models without requiring additional training.
2. We introduce **region-guided rectification** and **region-aligned cross-attention** mechanisms to improve control ability during the diffusion sampling process.
3. Extensive experiments show that ReCon generates high-quality augmented data and substantially improves detection performance compared to both traditional augmentation techniques and current generative approaches.

---

## 🔍 3. Method Pipeline

<p align="center">
  <img src="figure/overview.png" alt="method pipeline" />
</p>

Please refer to the paper for more technical details.

---

## 🛠️ 4. How to Run Experiments?

### 🔧 4.1 Setup & Preparation

**Create the environment:**

```bash
conda create -n recon python=3.10.6 -y
conda activate recon
```


* Install necessary python libraries:

```bash
pip install -r requirements.txt
```

**Data Preparation:**

The main dataset used in our work is COCO, it should be  prepared in `./data/`. The structure is like:

```bash
./data
└── coco
    ├── annotations
    ├── train2017
    └── val2017
```

**Model Preparation:**

Download the Grounding-DINO model `IDEA-Research/grounding-dino-tiny` and the SAM model weights `sam_vit_h_4b8939.pth` into the `./ckpts/` directory. The directory structure should look like this:

```bash
./ckpts
├── grounding-dino-tiny
└── sam_vit_h_4b8939.pth
```

<hr />

### 4.2 Run Experiments
**1) Generate Dataset**
* Taking ControlNet-ReCon model as an example, generate data using:

```bash
python generate.py controlnet_recon --dataset_config_name configs/data/coco_512x512.py
```
* Generated data will be saved in `outputs/`.
  

**2) Training and Evaluation**
* After data augmentation, use the **MMDetection** framework to train and evaluate object detectors on the generated dataset.


<hr />




