_base_ = 'configs/data/faster-rcnn_r50_fpn_1x_coco.py'
dataset_type = 'COCODataset'
data_root = 'data/coco/'
img_norm_cfg = dict(
    mean=[127.5, 127.5, 127.5], std=[127.5, 127.5, 127.5], to_rgb=True)

train_pipeline = [
    dict(type='LoadImageFromFile'),
    dict(type='LoadAnnotations', with_bbox=True),
    dict(type='Resize', scale=(512, 512), keep_ratio=False),
    dict(type='RandomFlip', prob=0.5),
    dict(type='Normalize', **img_norm_cfg),
    dict(type='Pad', size_divisor=8),
]

test_pipeline = [
    dict(type='LoadImageFromFile'),
    dict(type='LoadAnnotations', with_bbox=True),
    dict(type='Resize', scale=(512, 512), keep_ratio=False),
    dict(type='RandomFlip', prob=0.0),
    dict(type='Normalize', **img_norm_cfg),
    dict(type='Pad', size_divisor=8),
]

train_dataloader = dict(
    batch_size=2,
    num_workers=2,
    dataset=dict(
        type=dataset_type,
        data_root=data_root,
        data_prefix=dict(img='train2017'),
        pipeline=train_pipeline,
        serialize_data=False,
        # filter_cfg=dict(filter_empty_gt=True, min_size=32, bbox_min_size=32),
        )
    )

val_dataloader = dict(
    samples_per_gpu=1,
    workers_per_gpu=2,
    dataset=dict(
        type=dataset_type,
        test_mode=False,
        data_root=data_root,
        data_prefix=dict(img='val2017'),
        pipeline=test_pipeline,
        serialize_data=False,
        # filter_cfg=dict(filter_empty_gt=True, min_size=32, bbox_min_size=32),
        )   
    )
evaluation = dict(interval=1, metric='bbox')
