import matplotlib.pyplot as plt
from PIL import Image, ImageDraw


# colors for visualization
COLORS = [[0.000, 0.447, 0.741], [0.850, 0.325, 0.098], [0.929, 0.694, 0.125],
          [0.494, 0.184, 0.556], [0.466, 0.674, 0.188], [0.301, 0.745, 0.933]]

def plot_results(pil_img, scores, labels, boxes, file_name="Groudingdino_det.png", de_normalze=False):
    plt.figure(figsize=(16,10))
    plt.imshow(pil_img)
    ax = plt.gca()
    colors = COLORS * 100
    if scores is not None:
        for score, label, (xmin, ymin, xmax, ymax), c in zip(scores, labels, boxes, colors):
            if de_normalze:
                xmin, ymin, xmax, ymax = [int(i * 512) for i in (xmin, ymin, xmax, ymax)]
            ax.add_patch(plt.Rectangle((xmin, ymin), xmax - xmin, ymax - ymin,
                                    fill=False, color=c, linewidth=3))
            label = f'{label}: {score:0.2f}'
            ax.text(xmin, ymin, label, fontsize=15,
                    bbox=dict(facecolor='yellow', alpha=0.5))
    else:
        for label, (xmin, ymin, xmax, ymax), c in zip(labels, boxes, colors):
            if de_normalze:
                xmin, ymin, xmax, ymax = [int(i * 512) for i in (xmin, ymin, xmax, ymax)]
            ax.add_patch(plt.Rectangle((xmin, ymin), xmax - xmin, ymax - ymin,
                                    fill=False, color=c, linewidth=3))
            label = f'{label}'
            ax.text(xmin, ymin, label, fontsize=15,
                    bbox=dict(facecolor='yellow', alpha=0.5))
    plt.axis('off')
    plt.savefig(file_name)
    
    
def create_polygon_mask(image_size, vertices):
    """
    Create a grayscale image with a white polygonal area on a black background.

    Parameters:
    - image_size (tuple): A tuple representing the dimensions (width, height) of the image.
    - vertices (list): A list of tuples, each containing the x, y coordinates of a vertex
                        of the polygon. Vertices should be in clockwise or counter-clockwise order.

    Returns:
    - PIL.Image.Image: A PIL Image object containing the polygonal mask.
    """

    # Create a new black image with the given dimensions
    mask_img = Image.new('L', image_size, 0)
    
    # Draw the polygon on the image. The area inside the polygon will be white (255).
    ImageDraw.Draw(mask_img, 'L').polygon(vertices, fill=(255))

    # Return the image with the drawn polygon
    return mask_img