## Setup

To set up the environment, simply run the following command in the project root:

```bash
bash setup.sh
```

The `setup.sh` script will automatically install all required Python packages and dependencies.  
Please ensure that Python and Conda are installed on your system before running the script.

---

## Required Data Files

The following files should be placed in the `data/` folder:

- `GQA_Q2Q_train.csv` &nbsp;&nbsp;&nbsp;&nbsp;: Training dataset  
- `GQA_Q2Q_valid.csv` &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;: Validation dataset  
- `GQA_Q2Q_test.csv` &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;: Test dataset  
- `undefined_Q2Q_sample.csv` &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;:  Samples for the machine annontation
- `images/` &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;: Image folder  for GQA dataset 
- `train_sceneGraphs.json` &nbsp;&nbsp;&nbsp;: Scene graphs for GQA dataset

You can download the official GQA dataset and related files from the following link:  
[https://cs.stanford.edu/people/dorarad/gqa/download.html](https://cs.stanford.edu/people/dorarad/gqa/download.html)

Please make sure all required files are present before running the scripts.

---

## Finetuning Sub-question Generator and Validator
To finetune the sub-question generator and validator models, follow these steps:

1. Copy all `GQA_Q2Q_*.csv` files from `data/` to `LLaVA/playground/data`.
2. Change your working directory to `LLaVA`.
3. Convert the training, validation, and test CSV files to `.jsonl` format for LLaVA input/output:
   - Run:
     ```bash
     bash scripts/convert_Q2Q.sh
     bash scripts/convert_checker.sh
     ```
4. Finetune the sub-question generator and checker models:
   - Run:
     ```bash
     bash scripts/v1_5/finetune_q2q_lora.sh
     bash scripts/v1_5/finetune_checker_lora.sh
     ```
5. Run inference on the validation and test sets:
   - Run:
     ```bash
     bash scripts/inference_q2q.sh
     bash scripts/inference_checker.sh
     ```
6. Evaluate the generated results:
   - Run:
     ```bash
     bash scripts/eval/q2q.sh
     bash scripts/eval/checker.sh
     ```

---

## Running Scripts
To run sub-question generation and VQA inference, follow these steps:

1. **Sub-question Generation:**
   - Run the following script:
     ```bash
     bash scripts/subq_gen/run_inference_subquestion_generation.sh
     ```

2. **VQA Inference:**
   - For the proposed method:
     ```bash
     bash scripts/vqa/run_inference_vqa.sh
     ```
   - For the original VQA model:
     ```bash
     bash scripts/vqa/run_inference_vqa.sh
     ```


## Runing RepARe
Original source code: [https://github.com/archiki/RepARe](https://github.com/archiki/RepARe)  
Paper link: [https://arxiv.org/abs/2310.05861](https://arxiv.org/abs/2310.05861)

cd Lavis
pip install -e .

- **For BLIP-2:**
  ```bash
  cd Lavis
  python evaluate.py --cfg-path lavis/projects/blip2/gqa_par_zeroshot_flant5xl_eval.yaml
  ```

- **For InstructBLIP:**  
  (Custom implementation)
  ```bash
  cd Lavis
  python evaluate.py --cfg-path lavis/projects/instructblip/gqa_par_zeroshot_flant5xl_eval.yaml
  ```