#painting: 47.637, infograph: 34.56, real: 75.714, quickdraw: 59.091, clipart: 57.663, sketch: 43.384, train_syn_base/Epoch 5: Accuracy = 58.054
from collections import defaultdict
import statistics
accs = defaultdict(list)
train_settings = set()
# file_path = '/root/InterpretDiffusion/logs_domainnet/local_16shots_pretrained.txt'
file_path = '/root/InterpretDiffusion/logs_domainnet/log_train_syn_wnoise_0.1_interpolated_160.txt'

if 'pacs' in file_path:
    domains = ['art_painting', 'cartoon', 'photo', 'sketch']
elif 'officehome' in file_path:
    domains = ['Art', 'Clipart', 'Product', 'Real']
elif 'domainnet' in file_path:
    domains = ['clipart', 'infograph', 'painting', 'quickdraw', 'real', 'sketch']
else:
    domains = ['client_0', 'client_1', 'client_2', 'client_3', 'client_4']
domains += ['average']

with open(file_path, 'r') as f:
    max_ep_num = 0
    for l in f.readlines():        
        if 'Epoch ' in l:
            ep_num = int(l.split('Epoch ')[1].split(':')[0])
            max_ep_num = max(max_ep_num, ep_num)
max_ep_num =25

with open(file_path, 'r') as f:
    for l in f.readlines():
        if f'Epoch {max_ep_num}:' in l:
            if 'local' in file_path:
                acc = float(l.split('= ')[1])
                domain = l.split(': ')[1].split(' ')[0]
                accs[f'{domain}'].append(acc)
                accs['average'].append(acc)
            else:
                train_setting = l.split('/')[0].split(', ')[-1]
                train_settings.add(train_setting)
                average_acc = float(l.split('= ')[1])
                for p in l.split(', ')[:-1]:
                    domain = p.split(': ')[0]
                    acc = float(p.split(': ')[1])
                    accs[f'{train_setting}_{domain}'].append(acc)
                accs[f'{train_setting}_average'].append(average_acc)

if 'local' in file_path:
    o = ''
    for k in domains:
        acc = round(sum(accs[k])/len(accs[k]), 2)
        std = round(statistics.stdev(accs[k]), 2)
        o += f'\makecell[c]{{{acc}\\\\{{\\tiny ±{std}}}}} & '
    print(o)
    exit

o = ''
for train_setting in train_settings:
    for domain in domains:
        # o = f'{train_setting}_{domain}'        
        # o += f': {round(sum(accs[f"{train_setting}_{domain}"])/len(accs[f"{train_setting}_{domain}"]), 3)}'
        # o += f' ({round(statistics.stdev(accs[f"{train_setting}_{domain}"]), 3)})'

        acc = round(sum(accs[f"{train_setting}_{domain}"])/len(accs[f"{train_setting}_{domain}"]), 2)
        std = round(statistics.stdev(accs[f"{train_setting}_{domain}"]), 2)
        o += f'\makecell[c]{{{acc}\\\\{{\\tiny ±{std}}}}} & '
print(o[:-2])

                
