#!/bin/bash
NUM_SHOTS=(-1)
DATASETS=("officehome")
CLIENT_NUM=(1 2 3 4 5)
idx=0
for DATASET in "${DATASETS[@]}"
do
    for N_SHOT in "${NUM_SHOTS[@]}"
    do
        for CLIENT_N in "${CLIENT_NUM[@]}"
        do        
            CUDA_VISIBLE_DEVICES=$idx python clf_train_fedavg_multiclient.py \
                --dataset=$DATASET \
                --num_shot=$N_SHOT \
                --train_type='train' \
                --pretrained  > logs_${DATASET}/fedavg_${N_SHOT}shots_pretrained_${CLIENT_N}client.txt 
            idx=$((idx+1))
        done
    done
done