#!/bin/bash
idx=4
NUM_SHOTS=(160 240 320)
DATASETS=("domainnet")
for DATASET in "${DATASETS[@]}"
do
    for N_SHOT in "${NUM_SHOTS[@]}"
    do
        TRAIN_TYPE="train_syn_wnoise_0.1_interpolated_${N_SHOT}"
        CUDA_VISIBLE_DEVICES=$idx python clf_train_syn_only.py \
            --train_type $TRAIN_TYPE \
            --dataset $DATASET \
            --pretrained \
            > logs_${DATASET}/log_${TRAIN_TYPE}.txt &
        idx=$((idx+1))
    done
done

# NUM_SHOTS=(80)
# DATASETS=("officehome")
# for DATASET in "${DATASETS[@]}"
# do
#     for N_SHOT in "${NUM_SHOTS[@]}"
#     do
#         TRAIN_TYPE="train_syn_wnoise_0.1_w_cprompt_${N_SHOT}"
#         CUDA_VISIBLE_DEVICES=$idx python clf_train_syn_only.py \
#             --train_type $TRAIN_TYPE \
#             --dataset $DATASET \
#             --pretrained \
#             > logs_${DATASET}/log_${TRAIN_TYPE}.txt

#         TRAIN_TYPE="train_syn_wnoise_0.1_w_dprompt_${N_SHOT}"
#         CUDA_VISIBLE_DEVICES=$idx python clf_train_syn_only.py \
#             --train_type $TRAIN_TYPE \
#             --dataset $DATASET \
#             --pretrained \
#             > logs_${DATASET}/log_${TRAIN_TYPE}.txt
        
#         TRAIN_TYPE="train_syn_wnoise_0.1_w_latent_${N_SHOT}"
#         CUDA_VISIBLE_DEVICES=$idx python clf_train_syn_only.py \
#             --train_type $TRAIN_TYPE \
#             --dataset $DATASET \
#             --pretrained \
#             > logs_${DATASET}/log_${TRAIN_TYPE}.txt
#     done
# done