#!/bin/bash
idx=4
N_CLIENTS=(5)
DATASETS=("domainnet")
for DATASET in "${DATASETS[@]}"
do
    for N_CLIENT in "${N_CLIENTS[@]}"
    do
        TRAIN_TYPE="train_syn_wnoise_0.1_multiclient_${N_CLIENT}_160"
        CUDA_VISIBLE_DEVICES=$idx python clf_train_syn_only.py \
            --train_type $TRAIN_TYPE \
            --dataset $DATASET \
            --client_num $N_CLIENT \
            --pretrained \
            > logs_${DATASET}/log_${TRAIN_TYPE}.txt &
        idx=$((idx+1))
    done
done