# Pareto-Frontier-aware Neural Architecture Search

PyTorch implementation of "Pareto-Frontier-aware Neural Architecture Search".

## Requirements

```
python>=3.6, pytorch>=1.2, torchvision>=0.4.0, tb-nightly
```

Please install the all above packages using `pip install -r requirements.txt`.


## Data Preparation
We first sample 16,000 architectures from the search space. Then, we record the validation accuracy, the latency on CPU (Intel i5-7400), GPU (NVIDIA TITAN X) and mobile phone (Google Pixel1) of these architectures in the file (`assets/architectures.json`).

## Training Method

Train PFNAS to search for architectures on CPU devices.
```
bash search_on_cpu.sh /path/to/imagenet
```

Train PFNAS to search for architectures on GPU devices.
```
bash search_on_gpu.sh /path/to/imagenet
```

Train PFNAS to search for architectures on mobile devices.
```
bash search_on_mobile.sh /path/to/imagenet
```
