#!/bin/bash

num_particles_per_group=4
ns=1; nss=500; lambda_p=0.1; batch_size=16;

for i in 0 2 5 6; do
    python m_eval_wrn_ebm.py --save_dir ./samples_mc   --eval mc_cond_samples   --sgld_lr 1.0 --sgld_std 0.01  --lambda_p 0.0       --n_sample_steps $nss --buffer_size $batch_size --batch_size $batch_size --n_steps $ns --print_every 50 --reinit_freq 0.0 --m_class $i
    python m_eval_wrn_ebm.py --save_dir ./samples_hmc  --eval hmc_cond_samples  --sgld_lr 0.2 --sgld_std 0.004 --lambda_p 0.0       --n_sample_steps $nss --buffer_size $batch_size --batch_size $batch_size --n_steps $ns --print_every 50 --reinit_freq 0.0 --m_class $i
    python m_eval_wrn_ebm.py --save_dir ./samples_lmc  --eval lmc_cond_samples  --sgld_lr 1.0 --sgld_std 0.01  --lambda_p $lambda_p --n_sample_steps $nss --buffer_size $batch_size --batch_size $batch_size --n_steps $ns --print_every 50 --reinit_freq 0.0 --m_class $i --num_particles_per_group $num_particles_per_group
    python m_eval_wrn_ebm.py --save_dir ./samples_lhmc --eval lhmc_cond_samples --sgld_lr 0.2 --sgld_std 0.004 --lambda_p $lambda_p --n_sample_steps $nss --buffer_size $batch_size --batch_size $batch_size --n_steps $ns --print_every 50 --reinit_freq 0.0 --m_class $i --num_particles_per_group $num_particles_per_group
done