import torch
import torch.nn as nn

class HardwareReLU(nn.Module):
    def __init__(self, x_offset, y_offset):
        super(HardwareReLU, self).__init__()

        self.x_offset = x_offset
        self.y_offset = y_offset
        # 0.25, 0.6

    def forward(self, x):
        return torch.min(
            torch.max(torch.tensor(self.x_offset), x - torch.tensor(self.y_offset)), 
            torch.tensor(1.0)
        )