#!/bin/bash

# Select devices
export CUDA_VISIBLE_DEVICES=3,5

# SBETA SWEEP

n_hparams_per_algorithm=8

python -m advbench.scripts.sweep launch \
    --dataset CIFAR10 \
    --algorithms SBETA \
    --n_hparams $n_hparams_per_algorithm \
    --n_trials 1 \
    --data_dir ./advbench/data \
    --evaluators Clean PGD FGSM BETA AutoAttack \
    --command_launcher multi_gpu \
    --output_dir beta_cifar_sweep

# BASELINES SWEEP

python -m advbench.scripts.sweep launch \
    --dataset CIFAR10 \
    --algorithms TRADES MART FGSM PGD \
    --n_hparams 1 \
    --n_trials 1 \
    --data_dir ./advbench/data \
    --evaluators Clean PGD FGSM BETA AutoAttack \
    --command_launcher multi_gpu \
    --output_dir baselines_cifar_sweep
