#!/bin/bash


learning_rates=(0.01)
steps=(1 25 50 100)
batch_size=100

for lr in ${learning_rates[@]}; do
    for n_steps in ${steps[@]}; do
        fname="robustbench/robustbench_lr_${lr}_steps_${n_steps}"
        echo $fname
        python -m advbench.scripts.robustbench \
            --output_dir $fname \
            --data_dir ./advbench/data \
            --beta_lr $lr \
            --beta_n_steps $n_steps \
            --batch_size $batch_size 
    done
done