# Safe Multi-agent Reinforcement Learning with Protection Motivation Theory

Open-source code for[Safe Multi-agent Reinforcement Learning with Protection Motivation Theory].

The paper is submitted to NeurIPS 2024 and the submission number is 3613. The proposed safety guarantee methods, F4SG and R4SG, are inspired by Protection Motivation Theory from social psychology, which facilitate multiple agents learning strategies cooperatively and safely. 

## Environments Supported:

- [Safety Multi-Agent Mujoco]

## 1. Installation instructions

pip install -r requirements.txt
conda install pytorch torchvision torchaudio cudatoolkit=10.1 -c pytorch -c nvidia

## 2. Train

### 2.1 2x4 Ant
```
cd F4SG/f4sg/scripts or cd R4SG/r4sg/scripts
sh 2x4-train_mujoco.sh 
```

### 2.1 4x2 Ant
```
cd F4SG/f4sg/scripts or cd R4SG/r4sg/scripts
sh 4x2-train_mujoco.sh 
```




