# Instructions

The provided code is based on the `CompVis/latent-diffusion` repository. Please follow the instructions at [GitHub - CompVis/latent-diffusion: High-Resolution Image Synthesis with Latent Diffusion Models](https://github.com/CompVis/latent-diffusion) to install Python dependencies and download pre-trained LDM models. 

After setting up, the severity encoder can be fine-tuned from the LDM encoder via 

```bash
python ldm_examples/train_severity_encoder.py --dataset 'celeba256' \
                                                --default_root_dir DATA_PATH \
                                                --devices 8 \
                                                --sample_rates 1.0 1.0 1.0 \
                                                --batch_size 4 \
                                                --lr_gamma 0.1 \
                                                --max_epochs 200 \
                                                --lr 0.0001 \
                                                --weight_decay 0.0 \
                                                --verbose \
                                                --logger_type 'wandb' \
                                                --experiment_name 'sev-enc-celeba' \
                                                --experiment_config_file 'configs/inverse_configs/gaussian_blur_fixed_noise.yaml'\
                                                --ldm_model_ckpt_path LDM_CKPT_PATH \
                                                --ldm_model_config_path LDM_CONFIG_FILE \
                                                --sigma_reg 10.0 \
                                                --img_space_reg 1.0 \
                                                --save_checkpoints 
```

where DATA_PATH should point to the root directory for the CelebA-HQ dataset, LDM_CKPT_PATH to the pre-trained LDM checkpoint and LDM_CONFIG_FILE to the corresponding LDM config file (typically in the same folder).

Once the severity encoder is trained, inference on the test set can be run by 

```bash
python scripts/reconstruction.py --recon_config_path 'configs/reconstruction_configs/flash-diffusion/blur/celeba256_blur_ours_config.yaml' \
                                                      --logdir LOGGING_DIR \
                                                      --evaluate \
                                                      --evaluate_gen_metrics
```

where the output will be saved at LOGGING_DIR, and the reconstruction config file has to be updated with the path to the dataset and pre-trained checkpoints (as above). All metrics (LPIPS, FID, PSNR) will be evaluated automatically and saved in the output directory along with the reconstructed images.
