import os
import re
from pathlib import Path
import shutil

def rename_merge_data_files(root_dir):
    """
    递归处理所有 part 子目录下的 merge_data 文件
    参数:
        root_dir: 根目录路径 (如 "./data/part")
    """
    # 编译正则表达式匹配 merge_data_数字
    pattern = re.compile(r'merge_data_(\d+)')
    
    # 遍历所有子目录
    for dirpath, dirnames, filenames in os.walk(root_dir):
        print(dirpath)
        print(dirnames)
        print(filenames)
        # 只处理包含 merge_data 文件的目录
        if not any(f.startswith('merge_data_') for f in dirpath):
            continue
        
        # 从路径中提取日期 (如 ".../0506/..." → "0506")
        date_match = re.search(r'/(\d{4})/', dirpath.replace('\\', '/'))
        if not date_match:
            print(f"⚠️ 无法从路径提取日期: {dirpath}")
            continue
        date_prefix = date_match.group(1)
        
        # 处理当前目录下的文件
        for filename in filenames:
            match = pattern.match(filename)
            if match:
                file_num = match.group(1)
                old_path = Path(dirpath) / filename
                new_name = f"{date_prefix}_{file_num}{old_path.suffix}"
                new_path = old_path.with_name(new_name)
                
                # 执行重命名
                old_path.rename(new_path)
                print(f"重命名: {old_path} → {new_path}")

def get_folders_fast(path):
    """高性能获取文件夹列表（推荐）"""
    with os.scandir(path) as entries:
        return [entry.name for entry in entries if entry.is_dir()]
    
def get_files_fast(path):
    """高性能获取文件列表（推荐）"""
    with os.scandir(path) as entries:
        return [entry.name for entry in entries if entry.is_file()]

# 使用示例 - 处理所有 part 目录
if __name__ == "__main__":
    # base_dir = "./part3"  # 根据实际结构调整
    # rename_merge_data_files(base_dir)

    time_last =['iphone1','iphone2','iphone3']
    area_last = ['2A']
    phone_lase = ['1+ace2','honor60','honormagic4p','honorX10','mate10','meizu16s','pixel4','iphone11','iphone12','iphone13','iphone13mini'
                  'iphone14','iphone14pro','iphone15pm','redmik20p','redmiK30SUltra','redmiK40','redminote12-turbo','xiaomi8se','xiaomi13-1','xiaomi13-2','xiaomi14']


    for time_idx in time_last:
        for area_idx in area_last:
            DATA_DIR1 = os.path.join('./data/', 'part')
            DATA_DIR2 = os.path.join(DATA_DIR1, time_idx)
            DATA_DIR3 = os.path.join(DATA_DIR2, area_idx)
            DATA_DIR4 = os.path.join(DATA_DIR3, 'window_ap_num-6_seq_ap_num-5_time_step-0.5_time_window-0.5')
            for phone_idx in phone_lase:
                DATA_DIR5 = os.path.join(DATA_DIR4, phone_idx)

                # 新增路径存在性检查
                if not os.path.exists(DATA_DIR5):
                    print(f"路径不存在，跳过: {DATA_DIR5}")
                    continue  # 跳过当前循环

                folders = get_folders_fast(DATA_DIR5)
                print(folders)

                for f_idx in folders:
                    f_idx_num = f_idx[10:]
                    print(f_idx_num)
                    DATA_DIR6 = os.path.join(DATA_DIR5, f_idx)
                    files = get_files_fast(DATA_DIR6)

                    for file in files:
                        DATA_DIR7 = os.path.join(DATA_DIR6, file)

                        SAVE_DIR1 = os.path.join('./data/', 'part4')
                        SAVE_DIR2 = os.path.join(SAVE_DIR1, phone_idx)
                        SAVE_DIR3 = os.path.join(SAVE_DIR2, area_idx)
                        SAVE_DIR4 = os.path.join(SAVE_DIR3, 'window_ap_num-6_seq_ap_num-5_time_step-0.5_time_window-0.5')
                        new_name = f"{phone_idx}{f_idx_num}"
                        SAVE_DIR5 = os.path.join(SAVE_DIR4, new_name)
                        new_name2 = f"{time_idx}{f_idx_num}"
                        SAVE_DIR5 = os.path.join(SAVE_DIR5, new_name2)
                        SAVE_DIR5 = Path(SAVE_DIR5)
                        DATA_DIR7 = Path(DATA_DIR7)
                        SAVE_DIR5.mkdir(parents=True, exist_ok=True)
                        shutil.copy2(DATA_DIR7, SAVE_DIR5)






            # SAVE_DIR1 = os.path.join('./test_runs/', time_idx)
            # SAVE_DIR = os.path.join(SAVE_DIR1, area_idx)