# Configuration Files

This directory contains all configuration files for the D-MOE-EVAL framework.

## Files

### `requirements.txt`
Python package dependencies required to run the D-MOE-EVAL framework.

**Installation:**
```bash
pip install -r config/requirements.txt
```

### `pyproject.toml`
Modern Python project configuration file containing:
- Project metadata and description
- Build system configuration
- Development dependencies
- Tool configurations (black, mypy, pytest)

**Installation:**
```bash
pip install -e ".[dev]"
```

### `config.env.template`
Environment configuration template for API keys and settings.

**Setup:**
1. Copy this file to `.env` in the project root
2. Fill in your actual API keys and configuration values

```bash
cp config/config.env.template .env
# Edit .env with your actual values
```

## Usage

All configuration files are designed to work together:
1. **Install dependencies** using `requirements.txt` or `pyproject.toml`
2. **Configure environment** using `config.env.template`
3. **Run the framework** with proper configuration

## Security Note

Never commit actual API keys or sensitive configuration to version control. Always use the template file and keep your `.env` file local.
