# Datasets

This directory contains the datasets used for evaluation in the D-MOE-EVAL framework.

## Structure

```
datasets/
├── llmbar/           # LLMBar benchmark datasets
│   ├── gptout/       # GPTOut dataset
│   ├── natural/      # Natural dataset  
│   ├── manual/       # Manual dataset
│   └── neighbor/     # Neighbor dataset
├── md_eval/          # MD-Eval dataset
├── data/             # Database storage structure
│   ├── llmbar/       # LLMBar dataset storage
│   └── md_eval/      # MD-Eval dataset storage
└── README.md         # This file
```

## Dataset Descriptions

### LLMBar Datasets
- **GPTOut**: Generated outputs from GPT models
- **Natural**: Natural language processing tasks
- **Manual**: Manually curated evaluation instances
- **Neighbor**: Contextually similar evaluation instances

### MD-Eval Dataset
- **MD-Eval**: Multi-dimensional evaluation dataset for comprehensive LLM assessment

## Usage

Place your dataset files in the appropriate subdirectories following the expected format for each evaluation script.
