#!/usr/bin/env python3

"""
Entry point for running the Integrated MOE and Jury Debate System.

This script delegates to `src/main_pipeline/integrated_jury_system.py` so that
you can run the pipeline via:

    python -m D-MOE-EVAL.main [args]
or
    python D-MOE-EVAL/main.py [args]

It accepts the same CLI arguments as `integrated_jury_system.py`.
"""

from src.main_pipeline.integrated_jury_system import main as integrated_main
import sys


def main():
    # If no arguments are provided, show a concise usage and then display full --help
    if len(sys.argv) == 1:
        print(
            "\nIntegrated MOE + Jury System (entrypoint)\n"
            "\nQuick examples:\n"
            "  python D-MOE-EVAL/main.py --api_key_1 YOUR_KEY \\\n+    --base_url https://api.your-provider.com \\\n+    --seeds_path D-MOE-EVAL/datasets/md_eval/seeds.json \\\n+    --metrics_path D-MOE-EVAL/datasets/md_eval/metrics.yaml \\\n+    --mode parallel --nums 50\n\n"
            "  python D-MOE-EVAL/main.py --api_key_1 KEY1 --api_key_2 KEY2 --workers 19 --max_rounds 4 --delay 2\n\n"
            "Showing full help below...\n"
        )
        sys.argv.append("--help")
    integrated_main()


if __name__ == "__main__":
    main()


