#!/bin/bash

python=$(which python)

DATASET="CIFAR10"
MODELS=("ResNet18" "ResNet50" "ResNet101")

for SEED in 0 42 314; do
	for MODEL in ${MODELS[@]}; do
		$python -u main.py ${MODEL} --dataset $DATASET --architecture "resnet" -bn --seed $SEED > "/tmp/${MODEL}_resnet_he_fi_${SEED}"

	 	$python -u main.py ${MODEL} --dataset $DATASET --architecture "id_const" --fan_out --seed $SEED > "/tmp/${MODEL}_const_he_fo_${SEED}"
		$python -u main.py ${MODEL} --dataset $DATASET --architecture "short_mult" --fan_out --seed $SEED > "/tmp/${MODEL}_mult_he_fo_${SEED}"
		$python -u main.py ${MODEL} --dataset $DATASET --architecture "short_conv" --fan_out --seed $SEED > "/tmp/${MODEL}_conv_he_fo_${SEED}"

		$python -u main.py ${MODEL} --dataset $DATASET --architecture "id_const" --brock --seed $SEED > "/tmp/${MODEL}_const_brock_fi_${SEED}"
		$python -u main.py ${MODEL} --dataset $DATASET --architecture "short_mult" --brock --seed $SEED > "/tmp/${MODEL}_mult_brock_fi_${SEED}"
		$python -u main.py ${MODEL} --dataset $DATASET --architecture "short_conv" --brock --seed $SEED > "/tmp/${MODEL}_conv_brock_fi_${SEED}"
	done
done
