#!bin/bash

python=$(which python)

DATASET="CIFAR10"

for MODEL in "ResNet18" "ResNet50" "ResNet34" "ResNet101" "ResNet152"; do
	$python -u signal_propagation_plots.py ${MODEL} --dataset $DATASET --architecture "resnet" -bn
	$python -u signal_propagation_plots.py ${MODEL} --dataset $DATASET --architecture "resnet"
	
	$python -u signal_propagation_plots.py ${MODEL} --dataset $DATASET --architecture "resnet" -bn --fan_ou
	$python -u signal_propagation_plots.py ${MODEL} --dataset $DATASET --architecture "resnet" --fan_out

	$python -u signal_propagation_plots.py ${MODEL} --dataset $DATASET --architecture "id_const" 
	$python -u signal_propagation_plots.py ${MODEL} --dataset $DATASET --architecture "short_mult"
	$python -u signal_propagation_plots.py ${MODEL} --dataset $DATASET --architecture "short_conv"
	
	$python -u signal_propagation_plots.py ${MODEL} --dataset $DATASET --architecture "id_const" --fan_out 
	$python -u signal_propagation_plots.py ${MODEL} --dataset $DATASET --architecture "short_mult" --fan_out
	$python -u signal_propagation_plots.py ${MODEL} --dataset $DATASET --architecture "short_conv" --fan_out

	$python -u signal_propagation_plots.py ${MODEL} --dataset $DATASET --architecture "id_const" --brock
	$python -u signal_propagation_plots.py ${MODEL} --dataset $DATASET --architecture "short_mult" --brock
	$python -u signal_propagation_plots.py ${MODEL} --dataset $DATASET --architecture "short_conv" --brock
done
