#!/bin/bash
seeds=(1 2 3 4 5)
alphas=(0.0 0.1 0.3 1.0 3.0)
epochs=35

for seed in ${seeds[@]}; do
    for alpha in ${alphas[@]}; do
        python  -m src.exec.llm --seed $seed --alpha $alpha --beta 0 --epochs $epochs
        python  -m src.exec.llm --oracle_z --seed $seed --alpha $alpha --beta 0 --epochs $epochs
        python  -m src.exec.llm --pretrained --seed $seed --alpha $alpha --beta 0 --epochs $epochs --overwrite
        python  -m src.exec.llm --pretrained --scaleweight --seed $seed --alpha $alpha --beta 0 --epochs $epochs
    done
done

