import json
from pathlib import Path

import hydra
from omegaconf import DictConfig

from rtrank.visualization import plot_results


@hydra.main(
    config_path="../../conf", config_name="visualization_config", version_base="1.3"
)
def main(cfg: DictConfig) -> None:
    results_dir = Path(cfg.results_dir)
    results_file = results_dir / "aggregated_results.json"

    with open(results_file, "r") as f:
        results = json.load(f)

    plot_results(results, results_dir)


if __name__ == "__main__":
    main()
