# Robust-Dataset-Distillation

## Requirements
- The code has been tested with PyTorch 2.0.1.   
- To run the codes, install package ```pip install fast-pytorch-kmeans```

## Experiment Commands
### SVHN
```
python distill_rdd.py --dataset=svhn --ipc=10 --layer=2 --eval_it=100 --space wp --learn_g --lr_g=0.01 --eval_mode=SVHN --depth=3
```

### CIFAR10
```
python distill_rdd.py --dataset=CIFAR10 --ipc=10 --layer=2 --eval_it=100 --space wp --eval_mode=CIFAR --depth=3
```

### ImageNet
```
python distill_rdd.py --dataset=imagenet-a --space=wp --eval_it=100 --layer=16 --ipc=10 --data_path={path_to_dataset}
```

## Test Commands
- You can put the condensed data at ```./test/results```.
- Set ```--data_dir``` and ```--imagenet_dir``` in ```argument.py``` to point the folder containing the original dataset.
- We provide some tests for robustness metrics. You first need to process the original dataset and then place it in the corresponding path. For details, please see the test_data function.
  
For example, to evaluate (10 images/class) on CIFAR-10 , run
```
python test_glad.py -d cifar10 -n convnet -s glad --ipc 10
```

You can also test the performance of other datasets by changing the parameters.
  
