from transformers import AutoModelForVision2Seq, AutoProcessor
import requests
from PIL import Image

model_name_or_path = "/mnt/lustrenew/mllm_safety-shared/models/huggingface/llava-hf/llava-v1.6-vicuna-7b-hf"

# default: Load the model on the available device(s)
model = AutoModelForVision2Seq.from_pretrained(
    model_name_or_path, torch_dtype="auto", device_map="auto"
)

processor = AutoProcessor.from_pretrained(model_name_or_path)

url1 = "https://aerospaceamerica.aiaa.org/wp-content/uploads/2023/06/0723_Aero_Starship-1200x675.jpg"
image1 = Image.open(requests.get(url1, stream=True).raw)

# Sample messages for batch inference
url2 = "https://huggingface.co/datasets/huggingface/documentation-images/resolve/0052a70beed5bf71b92610a43a52df6d286cd5f3/diffusers/rabbit.jpg"
image2 = Image.open(requests.get(url2, stream=True).raw)

text = "USER: <image>\n ASSISTANT:This is"
inputs = processor(
    text=[text, text],
    images=[[image1], [image2]],
    padding=True,
    return_tensors="pt",
)
inputs = inputs.to(model.device)

# Inference: Generation of the output
generated_ids = model.generate(**inputs, max_new_tokens=128)
generated_ids_trimmed = [
    out_ids[len(in_ids) :] for in_ids, out_ids in zip(inputs.input_ids, generated_ids)
]
output_text = processor.batch_decode(
    generated_ids_trimmed, skip_special_tokens=True, clean_up_tokenization_spaces=False
)
print(output_text)
