# default setup args
accelerate_config="deepspeed_zero2"
gpu=8
# default script args
model_name_or_path="/mnt/lustrenew/mllm_safety-shared/models/huggingface/Qwen/Qwen2-VL-7B"
data_config="animals/config_image"
data_overwrite_args=""
epochs=10
eval_steps=0.1
learning_rate=1e-5

# Parse kwargs
while [[ "$#" -gt 0 ]]; do
    case $1 in
        --accelerate_config) accelerate_config="$2"; shift ;;
        --gpu) gpu="$2"; shift ;;
        --model_name_or_path) model_name_or_path="$2"; shift ;;
        --data_config) data_config="$2"; shift ;;
        --data_overwrite_args) data_overwrite_args="$2"; shift ;;
        --data_output_field) data_output_field="$2"; shift ;;
        --epochs) epochs="$2"; shift ;;
        --learning_rate) learning_rate="$2"; shift ;;
        *) echo "Unknown parameter passed: $1"; exit 1 ;;
    esac
    shift
done

: "${data_output_field:=${data_config}}"
# Fail fast if we’d overwrite the original YAML in‑place
if [[ -n "${data_overwrite_args}" && "${data_output_field}" == "${data_config}" ]]; then
    echo "[ERROR] --data_overwrite_args was supplied, but --data_output_field is still '${data_config}'."
    echo "        Please set --data_output_field to a different name to avoid clobbering the original config."
    exit 1
fi

output_base_dir="models/${data_output_field}/$(basename ${model_name_or_path})/epochs${epochs}-lr${learning_rate}"
# for seed in $(seq 1 ${num_seeds}); do
seed=1
WANDB_MODE=disabled PYTHONPATH=. srun -p mllm_safety --quotatype=reserved --gres=gpu:${gpu} --cpus-per-task=16 --time=30000 \
    accelerate launch --config_file "scripts/accelerate_configs/${accelerate_config}.yaml" --num_processes ${gpu} --main_process_port $(( RANDOM % 1000 + 30000 )) \
    src/train.py \
    --model_name_or_path "${model_name_or_path}" \
    --data_config_path "data/${data_config}.yaml" \
    --data_overwrite_args "${data_overwrite_args}" \
    --per_device_train_batch_size $((8 / gpu)) \
    --num_train_epochs ${epochs} \
    --learning_rate ${learning_rate} \
    --seed ${seed} \
    --eval_strategy steps \
    --eval_steps ${eval_steps} \
    --output_dir "${output_base_dir}/seed-${seed}"
# done
# e.g., sh scripts/dev.sh --data_config "animals/config_image" --gpu 4 --model_name_or_path /mnt/lustrenew/mllm_safety-shared/models/huggingface/Qwen/Qwen2.5-VL-3B-Instruct
