# python data.py --base_dir /mnt/lustrenew/mllm_safety-shared/tmp/zhouzhanhui/v-oocr/4-28/models/imagenet_animals_v2 --output_path data_imagenet_animals_v2
import re
import tyro
import json
from pathlib import Path
from dataclasses import dataclass

import pandas as pd

@dataclass
class ScriptArguments:
    base_dir: str = "models"
    output_path: str = "data"

script_args = tyro.cli(ScriptArguments)

# Set the root directory to search for rank.json files
# root_dir = Path("models")
root_dir = Path(script_args.base_dir)

# Prepare storage for the final results
records = []

# Traverse the directory
for rank_file in root_dir.rglob("rank.json"):
    try:
        with open(rank_file, "r") as f:
            data = json.load(f)

        # Extract final values (last item in the list) for eval-0 and eval-1
        eval_0_mean = data.get("eval-0.0", {}).get("mean", [])
        eval_0_std = data.get("eval-0.0", {}).get("std", [])
        eval_1_mean = data.get("eval-1.0", {}).get("mean", [])
        eval_1_std = data.get("eval-1.0", {}).get("std", [])

        if eval_0_mean and eval_0_std and eval_1_mean and eval_1_std:
            model_path = rank_file.parent
            local_image_url = model_path / "rank.jpg"  # You can change to .png if needed

            relative_model_path = model_path.relative_to(root_dir)

            records.append({
                "Model Path": str(relative_model_path),
                "eval-0 mean": eval_0_mean[-1],
                "eval-0 std": eval_0_std[-1],
                "eval-1 mean": eval_1_mean[-1],
                "eval-1 std": eval_1_std[-1],
                "Image": f"[View Image]({local_image_url})"
            })
    except Exception as e:
        print(f"Error processing {rank_file}: {e}")

# Create DataFrame
df = pd.DataFrame(records)

# Custom sorting function
def extract_model_size(path):

    match = re.search(r"(\d+(?:\.\d+)?)[Bb]", path)
    if match:
        prefix_before_size = path.split(match.group(0))[0]
        size = float(match.group(1))

        # if "Llama-3.2-11B-Vision/" in path:
        #     return (prefix_before_size, 0)
        # if "Llama-3.2-11B-Vision-Instruct/" in path:
        #     return (prefix_before_size, 1)

        # if "Qwen2-VL-2B/" in path:
        #     return (prefix_before_size, 0)  # Base model comes first
        # if "Qwen2-VL-7B/" in path:
        #     return (prefix_before_size, 1)  # Base model comes first
        # if "Qwen2-VL-2B-Instruct/" in path:
        #     return (prefix_before_size, 2)  # Instruct model comes after base
        # if "Qwen2-VL-7B-Instruct/" in path:
        #     return (prefix_before_size, 3)  # Instruct model comes after base

        return (prefix_before_size, size)
    return (path, float('inf'))

# Sort and reset index
df_sorted = df.sort_values(by="Model Path", key=lambda col: col.map(extract_model_size)).reset_index(drop=True)
df.to_csv(f'{script_args.output_path}.csv', index=False)  # index=False prevents writing row numbers

# Write markdown table to README.md
with open(f'{script_args.output_path}.md', "w") as f:
    f.write("# Evaluation Summary\n\n")
    f.write(df_sorted.to_markdown(index=False))
