from transformers import AutoModelForVision2Seq, AutoProcessor
from qwen_vl_utils import process_vision_info
import requests
from PIL import Image

model_name_or_path = "/mnt/lustrenew/mllm_safety-shared/models/huggingface/Qwen/Qwen2-VL-7B-Instruct"

# default: Load the model on the available device(s)
model = AutoModelForVision2Seq.from_pretrained(
    model_name_or_path, torch_dtype="auto", device_map="auto"
)

min_pixels = 32*28*28
max_pixels = 128*28*28
processor = AutoProcessor.from_pretrained(model_name_or_path, min_pixels=min_pixels, max_pixels=max_pixels)
processor.tokenizer.padding_side="left"

url1 = "https://aerospaceamerica.aiaa.org/wp-content/uploads/2023/06/0723_Aero_Starship-1200x675.jpg"
image1 = Image.open(requests.get(url1, stream=True).raw)

# Sample messages for batch inference
url2 = "https://huggingface.co/datasets/huggingface/documentation-images/resolve/0052a70beed5bf71b92610a43a52df6d286cd5f3/diffusers/rabbit.jpg"
image2 = Image.open(requests.get(url2, stream=True).raw)
messages1 = [
    {
        "role": "user",
        "content": [
            {"type": "image", "image": image1},
            {"type": "text", "text": "Describe the image?"},
        ],
    }
]
messages2 = [
    {
        "role": "user",
        "content": [
            {"type": "image", "image": image2},
            {"type": "text", "text": "Describe the image?"},
        ],
    }
]
# Combine messages for batch processing
messages = [messages1, messages2]

# Preparation for batch inference
texts = [
    processor.apply_chat_template(msg, tokenize=False, add_generation_prompt=True)
    for msg in messages
]
image_inputs, video_inputs = process_vision_info(messages)
inputs = processor(
    text=texts,
    images=image_inputs,
    videos=video_inputs,
    padding=True,
    return_tensors="pt",
)
inputs = inputs.to(model.device)

# Batch Inference
generated_ids = model.generate(**inputs, max_new_tokens=128)
generated_ids_trimmed = [
    out_ids[len(in_ids) :] for in_ids, out_ids in zip(inputs.input_ids, generated_ids)
]
output_texts = processor.batch_decode(
    generated_ids_trimmed, skip_special_tokens=True, clean_up_tokenization_spaces=False
)
print(output_texts)
