# Set environment
export PYTHONPATH=.

# Base directories
src_base_dir="tmp/data/moderation_v2/files"
tgt_base_dir="tmp/data/moderation_v2/files/others/filter"
filter_class="Llama_Guard_3_11b_Vision_Filter"

# Patch ratios
for patch_ratio in 2 4 8; do
    # Find all subdirectories inside the ratio folder
    ratio="${patch_ratio}x${patch_ratio}"
    for src_subdir in "$src_base_dir/$ratio"/*; do
        if [ -d "$src_subdir" ]; then
            subdir_name=$(basename "$src_subdir")
            tgt_subdir="$tgt_base_dir/$ratio/$filter_class/safe/$subdir_name"

            echo "Processing $src_subdir -> $tgt_subdir"

            (
                srun -p mllm_safety --quotatype=reserved --gres=gpu:1 --cpus-per-task=8 --time=30000 \
                    python src/tools/patches_filter.py \
                    --src_patches_dir "$src_subdir" \
                    --tgt_patches_dir "$tgt_subdir" \
                    --filter_class_name "$filter_class"

                srun -p p-cpu-new --quotatype=reserved --cpus-per-task=8 --time=30000 \
                        python src/tools/patches_stitch.py \
                        --src_patches_dir "$tgt_base_dir/$ratio/$filter_class/safe/$subdir_name" \
                        --tgt_images_dir "$tgt_base_dir/$ratio/$filter_class/safe_stitched/$subdir_name" \
                        --patch_ratio ${patch_ratio}
            ) &
            sleep 0.5
        fi
    done
done
