# Set environment variables
export PYTHONPATH=.

# Input directory
input_dir="data/moderation_v2/files"

# Output base directory
output_base_dir="tmp/data/moderation_v2/files"

# Iterate over all images
for img_path in "$input_dir"/*.jpg; do
    img_filename=$(basename "$img_path")
    img_name="${img_filename%.*}"  # Remove .jpg suffix

    for patch_ratio in 2 4 8; do
    # 2x2 patches
        srun -p p-cpu-new --quotatype=reserved --cpus-per-task=8 --time=30000 \
            python src/tools/patches_split.py \
            --src_image_path "$img_path" \
            --tgt_patches_dir "$output_base_dir/${patch_ratio}x${patch_ratio}/$img_name" \
            --patch_ratio ${patch_ratio} &
        sleep 0.5
    done
done
