lov_guidance_llava = {
    'EuroSAT': 'Label the image as [one of the 10 classes] based on the prominent features and satellite features present, providing a concise description of the dominant land cover or vegetation type, and highlighting any notable patterns or structures in the image.',
    'OxfordFlowers':  'Identify the type of flower in this image and provide its common name e.g. \'This is a species of [Common Name]\.',
    'ImageNet': 'Can you describe the main subject or object in this image, highlighting its most distinctive visual features, typical attributes, and common name, and explain how it relates to its broader category by tracing its evolution through time, exploring its cultural and historical significance, and highlighting its relationships with other objects within that category, while also emphasizing the subtle nuances and peculiarities that set',
    'ImageNetV2': 'Can you describe the main subject or object in this image, highlighting its most distinctive visual features, typical attributes, and common name, and explain how it relates to its broader category by tracing its evolution through time, exploring its cultural and historical significance, and highlighting its relationships with other objects within that category, while also emphasizing the subtle nuances and peculiarities that set',
    'UCF101': 'Describe the human activity in this image, emphasizing the specific actions, objects, and actors involved, and identify the UCF101 category that best captures this action by highlighting the type of interaction (human-object, body-motion, human-human, or sports) and providing a detailed category name that accurately matches the action depicted, such as \'Human-Object Interaction',
    'ImageNetR': 'Can you describe the visual category depicted in this image by highlighting its creative context, notable features, and artistic medium, and specify the name of the corresponding ImageNet-R class while examining how the artwork reinterprets and recontextualizes the original ImageNet class\'s conventions, incorporating artistic liberties and creative flair',
    'ImageNetSketch': 'Envision the sketched representation of the object, highlighting its distinctive visual patterns, functional relationships with other ImageNet categories, and typical environments, while emphasizing its versatility and common associations, and crafting a nuanced description that accurately integrates its adaptability, potential applications, and versatility, ensuring a precise mention of the class name and corresponding ImageNet category.',
    'DescribableTextures': 'What specific texture category is present in this image, defined by its unique visual cues, spatial frequency, and luminance, as perceived by human observers, and characterized by its distinctive pattern of alternating attributes that vary in terms of roughness, softness, and bumpy or smooth features, while also considering the subtle interactions between these cues, the surrounding context,',
    'Food101': 'Vividly describe the image\'s composition, highlighting the main ingredients, cooking techniques, and presentation styles that make it unique, while specifying the exact category of food and briefly explaining the cultural significance of the dish, focusing on the sensory details that evoke a sense of warmth, comfort, and regional or international influences that shape the culinary tradition.',
    'FGVCAircraft': 'Can you identify the specific aircraft model or subcategory shown in this image, and mention a key distinguishing characteristic that is both visually apparent to a non-expert observer and closely related to the aircraft\'s design evolution or historical context?',
    'Caltech101': 'Classify this image as one of the 101 object categories in the Caltech 101 dataset, by pinpointing the object\'s most salient visual elements and its nuanced interactions with the surrounding environment, while providing a concise and accurate label for its corresponding category name that effectively captures the object\'s proportions, orientation, and subtle context-dependent appearances.',
    'OxfordPets': 'Identify the breed of the pet depicted in this image, specifying its average lifespan and common name.',
    'StanfordCars': 'Classify the image as a specific car model, emphasizing its striking design features, precise manufacturer, exact model year, and notable details, while highlighting the subtle variations in its color palette, trim levels, and overall styling to accurately categorize it among the fine-grained categories of cars.',
    'RESISC45': 'Can you describe the geographical feature or man-made structure depicted in the image, highlighting its unique characteristics, features, and patterns that make it distinct from other categories, and then consider the surrounding environment, terrain, and any notable visual anomalies or textures that provide contextual clues to help identify the category from RESISC45?',
    'ImageNetA': 'Interpret the image as a subtle anomaly within a broader category, where the depicted concept or object\'s distinctive features and deviations from typical expectations subtly alter our understanding of the category\'s identity and necessitate a nuanced classification.',
    'SUN397': 'Envision the scene in this image, where the masterful blend of visual and contextual nuances yields a distinct narrative, thoughtfully guiding you to intuit the specific category from the 397 SUN categories, with precision and attention to the intricate relationships that harmonize to define the scene\'s membership within its designated category, while subtly illuminating the most salient and characteristic.',
    }
lov_llava = {
    'EuroSAT': 'Label the image as [one of the 10 classes] based on the prominent features and satellite features present, providing a concise description of the dominant land cover or vegetation type, and highlighting any notable patterns or structures in the image.',
    'OxfordFlowers':  'Identify the specific type of flower depicted in this image, providing its botanical name and a detailed description of its unique characteristics, including its color palette, shape, texture, and any distinctive markings or patterns, while highlighting its botanical classification and the ways in which it has evolved to occupy a specific ecological niche in the diverse habitats and temperate maritime climate of',
    'ImageNet': 'Spot the distinctive visual cues, textures, or patterns in this image, linking them to the exact class name, while also considering the contextual elements that help disambiguate it from similar classes.',
    'ImageNetV2': 'Spot the distinctive visual cues, textures, or patterns in this image, linking them to the exact class name, while also considering the contextual elements that help disambiguate it from similar classes.',
    'UCF101': 'Elaborate on the specific attributes and characteristics of the human or object in the image that uniquely define the UCF101 action category, highlighting notable patterns, shapes, or movements that distinguish it from others, and further describe the context and scene where the action takes place.',
    'ImageNetR': 'Can you describe the visual category depicted in this image, weaving together artistic expression, cultural context, and semantic meaning to specify the ImageNet-R class that masterfully harmonizes creative and literal aspects of the depiction, while acknowledging the nuanced interplay between artistic interpretation, cultural influences, and original meaning in the representation?',
    'ImageNetSketch': 'Envision the original ImageNet object\'s most distinctive attributes and describe how the sketched representation masterfully captures these nuances, ensuring a precise correspondence to the class name.',
    'DescribableTextures': 'Identify the texture category and describe its characteristic visual pattern, emphasizing the striking visual cues that make it instantly recognizable within its category, while highlighting the most prominent feature that sets it apart from others.',
    'Food101': 'What type of food is depicted in this image, and how do its visual features, cultural associations, and culinary traditions coalesce to create a rich culinary identity that encompasses its unique flavors, cultural significance, and appeal?',
    'FGVCAircraft': 'Pinpoint the aircraft model, emphasizing its distinctive configuration of wings, fuselage, and control surfaces, while highlighting the nuanced variations that differentiate it from other models within the broader category of aircraft, and accurately distinguishing it from similar models.',
    'Caltech101': 'This object is a paradigmatic instance of [Caltech category name], exemplifying the core characteristics and features that define the concept and accurately capturing the essence of its category.',
    'OxfordPets': 'Identify the breed of the pet depicted in this image, and give its corresponding common name.',
    'StanfordCars': 'Describe the specific make and model of the car in the image, highlighting its unique design elements, notable features, and overall aesthetic appeal, while also analyzing its market positioning, technological advancements, and historical significance within the automotive industry, ultimately revealing its distinctiveness within its class.',
    'RESISC45': 'Can you describe the satellite or aerial photograph by focusing on the distinct spatial relationships and arrangements of geographical features or man-made structures that define its category, and then categorize it into one of the 45 categories in the RESISC45 dataset by emphasizing the unique characteristics that set it apart from other categories while considering the contextual information provided?',
    'ImageNetA': 'Describe the object or concept depicted in this image by highlighting the most significant visual cues that deviate from typical representations, and identify the category name while emphasizing the subtle differences between this instance and expected examples within the same class.',
    'SUN397': 'Classify the scene in this image by teasing out its intricate essence through a nuanced analysis of its visual topography, comprising the harmonious interplay of its most prominent elements, spatial arrangements, and subtle contextual cues, thereby pinpointing the precise SUN category that accurately captures its unique character and situates it within the 397 options.',
    }


lov_foci = { 
    'FGVCAircraft' : 'Can you describe the aircraft model and manufacturer depicted in this image, highlighting its most distinctive features and unique design elements that distinguish it from other similar models?',
    'OxfordPets' : 'What OxfordPets breed is this image most likely to belong to, considering the visual characteristics and features described in the Oxford-IIIT Pet Dataset?',
    'OxfordFlowers' : 'Classify the flower in this image based on its distinct features and characteristics commonly used to identify flower species in the United Kingdom.',
    'Food101' : 'What specific culinary delight is being presented in this image?',
    }
lov_guidance_foci = {
    'FGVCAircraft' : 'What aircraft model is depicted in this image, showcasing its unique design features, era of service, and remarkable feats in aviation, to accurately identify the specific aircraft model?',
    'OxfordPets' : 'What OxfordPets breed is highlighted in this image, and how does its distinctive appearance and characteristics contrast with those of other breeds?',
    'OxfordFlowers' : 'Can you please classify the flower species in this image, noting its genus and key features, and highlighting its unique characteristics that distinguish it from its closest relatives within the same genus while also specifying its exact category within the 102 types of flowers?',
    'Food101' : 'What food is being served in this image, considering its textures, colors, and culinary and cultural context, as well as its typical preparation and serving methods?',
    }


meta_prompt_llava = {
    'EuroSAT':'Label the image as [one of the 10 classes] based on the dominant land cover or vegetation type shown.',
    'OxfordFlowers':'Identify the specific type of flower depicted in this image, providing its botanical name.',
    'ImageNet':'Can you identify the main object in this image and provide its common name?',
    'ImageNetV2':'Can you identify the main object in this image and provide its common name?',
    'UCF101': 'In this image, an individual is performing ___________________________, which is a typical example of the ___________________________ category.',
    'ImageNetR':'Can you describe the visual category depicted in this image, mentioning the style, medium, and any notable features, and specify the name of this ImageNet-R class?',
    'ImageNetSketch':'Identify the sketched object and describe its purpose or function, ensuring the category name is accurately mentioned.',
    'DescribableTextures':'Identify the texture category and describe it in a few words, using attributes like rough, smooth, soft, hard, bumpy, etc.',
    'Food101':'Name the specific type of food shown in this image, such as \'pizza\' or \'sushi\', and provide a brief description of its characteristics.',
    'FGVCAircraft':'Identify the specific aircraft model shown in this image, providing a brief description of its distinguishing features.',
    'Caltech101':'Identify the object shown in the image and provide its corresponding category name, like \'watch\' for a timepiece or \'ant\' for a small insect, etc.',
    'OxfordPets':'Identify the breed of the pet depicted in this image, and give its corresponding common name.',
    'StanfordCars':'Describe the type of car in the image and provide its exact model name, if possible.',
    'RESISC45':'Identify the geographical feature or man-made structure present in the image, and briefly describe it, then state the corresponding category from RESISC45.',
    'ImageNetA':'Explain the concept or object depicted in this image and how it differs from a typical instance of the same category, including its name.',
    'SUN397':'Identify the scene in this image and categorize it into one of the 397 SUN categories.'
    }



lov_guidance_templates_clip = {
    "OxfordPets": ['A cherished and loyal {} with a warm and loving demeanor, often found in the hearts of its owners as a constant companion, bringing immense joy and comfort to their daily lives with its playful antics and snuggles.', "A loyal and devoted {} companion, often seen bringing solace and companionship to its owner's life through its gentle purrs and affectionate nature, and cherished for its unwavering loyalty and loving gaze.", "A majestic {} with a gentle purr, often seen lounging in the sunbeams that stream through the windows, bringing joy and comfort to its owner's life with its soft fur and loving companionship."],
    "OxfordFlowers": ['A picturesque {} unfurls its petals, emitting a subtle floral aroma as the morning dew glistens upon its delicate features.', 'A exquisite {} unfurls its tender petals, releasing a delicate fragrance that wafts gently on the morning air, as the warm sunlight dances across its velvety texture.', 'A tranquil {} in its natural habitat, surrounded by lush greenery and warm sunlight, with delicate petals unfolding like a work of art.'],
    "FGVCAircraft": ['"A photo of a {} aircraft, its worn <control surface texture> and faded <trim scheme pattern> blending into the cracked <concrete texture>', 'A photo of a {} aircraft, its streamlined <fuselage shape> and precise <ailerons texture> gliding smoothly against the soft focus of the distant <', 'A photo of a {} aircraft, its worn <livery pattern> and worn <landing gear> blending with the faded <tarmac texture> of the background, as it stands out against the soft focus of the blurry'],
    "DescribableTextures": ['A picture of a {} where the texture is a natural or inherent property of the object, rather than something applied or added.', 'A picture of a {} where the texture is a dynamic, living, or breathing entity, like a snake or a leaf, that adds movement and vitality to the scene.', "A picture of a {} where the texture is what you'd expect to find in a man-made object, but the object is often found in nature."],
    "EuroSAT": ['"a Sentinel-2 satellite image capturing the symphony of human and environmental harmonies in European {}, as technology\'s gaze harmonizes with nature\'s rhythm"', '"a Sentinel-2 satellite image revealing the harmonious fusion of European heritage and environmental sustainability in {}"', '"a Sentinel-2 satellite image charting the evolution of European identity through the prism of land use and land cover in {}"'],
    "RESISC45": ['"A high-angle aerial view of {}, emphasizing its unique patterns, textures, and spatial relationships with the surrounding landscape, while showcasing its role as a distinct hub of activity."', '"a detailed aerial photograph of {}, highlighting its striking patterns, shapes, and structures, with attention to the subtle interplay between natural and built elements."', '"a high-angle aerial view of {} from a unique perspective, highlighting its relationship with surrounding urban or natural features, and showcasing a blend of textures, shapes, and colors that define the area'],
    "StanfordCars": ['A photo of a {} parked in a modern garage, with a minimalist interior design and subtle hints of high-tech features, emphasizing its sleek design and advanced engineering.', 'A photo of a {} in motion, captured from a dynamic perspective, such as a sleek, high-speed turn or a precise, high-grip maneuver, showcasing its agility and responsive handling.', 'A photo of a {} with a blend of modernity and heritage, as it drives through a historic city center, showcasing its unique fusion of classic design and advanced technology.'],
    "Food101": ['"A {} culinary masterpiece, carefully crafted to delight the senses and leave you wanting more."', '"A {} delight on a plate, perfect for a quick snack or a special treat."', '"A warm, comforting bowl of {} on a chilly evening, perfect for a cozy night in."Please replace {} with the actual class names in the Food101 dataset.'],
    "SUN397": ['A peaceful haven of a {}, where natural serenity meets subtle human touch.', '"A picturesque snapshot of a {}, where human presence subtly shapes the serene ambiance."', "A captivating image of a {}, where vibrant colors and textures evoke a sense of wonder and curiosity.Let me know if you'd like me to generate another one!"],
    "Caltech101": ['A detailed, in-focus image of a {} against a clean or neutral background, showcasing its textures, colors, and any distinctive patterns or features, allowing the viewer to study its intricate details and distinguishing characteristics.', "A photo of a {} in its typical setting, with the object\'s unique features or details highlighted, and a blurred or subtle background that does not distract from the object\'s significance or characteristics.", '""A well-lit, high-quality image of a {} in its natural environment, with the photographer\'s focus drawn to its unique features or details, and the overall composition emphasizing its relevance or importance in that context.""'],
    "UCF101": ['The video captures a person skillfully executing a {} action that requires a high level of physical dexterity and coordination in the context of sports.', 'The {} action is a nuanced demonstration of human physical skill, requiring coordination and precise movements.', 'The video captures a person engaged in a meticulous and precise manner while performing the {} action, showcasing exceptional control and technique.'],
    "ImageNet": ['"A photo of an {} that stands out for its [unique feature or characteristic], such as [specific detail], which is often [adjective] for its kind, in a [context or environment]."Please replace <', '"A photo of an {} that exemplifies its distinctive features, such as [specific feature or behavior], in a [common or typical] setting, highlighting its [adjective, e.g. characteristic, notable, or defining', '"A photo of an {} exemplifying its unique style, such as [distinctive features or behaviors], that are often associated with its type and are [adjective, e.g. striking, recognizable, or distinctive], within'],
    "ImageNetSketch": ['A sketchy yet captivating description of a {}, highlighting its most striking aspects in a harmonious balance of simplicity, elegance, and whimsy.', ' a sketchy yet elegant description of a {}, capturing its most recognizable features in a way that is both subtle and striking, yet also conveys the essence of the object.', 'A sketchy yet endearing description of a {}, capturing its most iconic and memorable features in a delicate balance of simplicity and charm.'],
    "ImageNetV2": ['"A photo of an {} that stands out for its [unique feature or characteristic], such as [specific detail], which is often [adjective] for its kind, in a [context or environment]."Please replace <', '"A photo of an {} that exemplifies its distinctive features, such as [specific feature or behavior], in a [common or typical] setting, highlighting its [adjective, e.g. characteristic, notable, or defining', '"A photo of an {} exemplifying its unique style, such as [distinctive features or behaviors], that are often associated with its type and are [adjective, e.g. striking, recognizable, or distinctive], within'],
    "ImageNetA": ['"a photo of a situation where the absence or unexpected presence of a {} disrupts the viewer\'s initial expectation, requiring them to pause and re-assess the image to accurately classify it."', '"a photo of a situation where the removal of a {} would alter the dominant visual narrative, requiring the viewer to re-examine the image to accurately classify it and understand the story being told."', '"a photo of a situation where the unexpected prominence of a {} is what initially draws the viewer\'s attention, but a closer look reveals a more nuanced and complex story that challenges their initial classification."'],
    "ImageNetR": ['"A captivating, hand-painted rendition of a {}, blending traditional techniques with a touch of fantasy and whimsy."', '"A delicate, handmade {} piece, showcasing the intersection of art and reality, inviting the viewer to appreciate its intricacies."', '"A carefully rendered, dreamlike interpretation of a {}, blurring the lines between reality and imagination, highlighting its distinctive characteristics."Please replace {} with the actual class names from your dataset'],
}


lov_templates_clip = {
    'ImageNetR': ['"A visually striking {} artwork that celebrates the intersection of artistry and imagination, inviting the viewer to appreciate the creative expression and attention to detail."', '"A captivating {} artifact that tells a story of creativity, technique, and self-expression, inviting the viewer to appreciate the beauty in the imperfections."', '"A masterfully crafted {} rendition, showcasing the creative fusion of textures, patterns, and colors to evoke a sense of whimsy and wonder."Please replace {} with the actual class'], 
    'ImageNetA': ['"A photo that illustrates the subtle yet significant ways in which the absence or presence of a {} shapes the trajectory of a story, often in ways that are both unexpected and profound."', '"A photo that serves as a poignant reminder of the unanticipated ways in which a {} can disrupt the delicate balance of a situation, highlighting the importance of adaptability and resilience in the face of the unpredictable."', '"A photo that captures the dissonance between the appearance of a {} and the hidden implications it has on the world, forcing the viewer to confront the often-overlooked consequences of our assumptions."'], 
    'ImageNetSketch': ['"A photorealistic hand-drawn sketch of a {}, rendered with precision and attention to detail, allowing for a seamless blend of artistic flair and technical accuracy."', 'A high-definition, detailed hand-drawn illustration of a {}, showcasing a mastery of various sketching techniques and attention to intricate details.', '"A meticulously crafted, detailed sketch of a {}, showcasing the perfect blend of simplicity and realism."'], 
    'RESISC45': ['"a satellite image of a {} from a moderate altitude, showcasing its unique characteristics and features in a clear and well-defined manner."', '"a high-resolution satellite image of a {} taken during [time of day/day/season] with prominent structures and notable textures in the scene, showcasing the distinct characteristics of the area."', '"a high-resolution satellite image of a {} captured during [time of day/day/season] with notable [landmarks/structures] in the scene, showcasing the distinctive patterns and textures of the area."'], 
    'EuroSAT': ['"A Sentinel-2 satellite image from the European continent, showcasing the complex relationships between built environments, agricultural practices, and natural ecosystems, as seen in a {} landscape, where the interplay between human activity and environmental health is', '"A Sentinel-2 satellite image from the European continent, where the nuanced interplay between urbanization, agriculture, and natural habitats takes center stage, highlighting the intricate connections between a {}\'s ecosystems and human activity."', '"A Sentinel-2 satellite image from the European continent, showcasing the synergistic relationship between built infrastructure, agriculture, and ecosystem services in a {}, where changes in land use and land cover are a key indicator of environmental health and'], 
    'ImageNetV2': ['"a precise and detailed image of a {} showcasing its most distinctive or defining features."', '"a photograph of a {} showcasing its most distinctive or iconic features."', '"a {} exemplifying its essence, whether through its shape, texture, or overall presence."'],
    'ImageNet': ['"a precise and detailed image of a {} showcasing its most distinctive or defining features."', '"a photograph of a {} showcasing its most distinctive or iconic features."', '"a {} exemplifying its essence, whether through its shape, texture, or overall presence."'],
    'OxfordPets': ["A picture of a {} that has captured the hearts of many, often becoming a beloved and loyal companion in its owner's life, bringing joy and happiness to those around it.", "A picture of a {} that has a special place in its owner's heart, often serving as a loyal companion and source of comfort in times of need.", 'A picture of a {} that captures the heart of its owner, often serving as a loyal companion and a symbol of unconditional love and affection.'],
    'SUN397': ['"A close-up shot of a {} that reveals its intricate textures and details, inviting a sense of curiosity and exploration."', 'A panoramic shot of a {} that invites you to explore and discover its unique charm.', 'A photo of a {} that tells a story of human connection and presence within its tranquil and serene environment.'], 
    'StanfordCars': ['A photo of a {} parked in front of a vintage, restored garage, with worn, rustic walls and a nostalgic atmosphere, highlighting its classic design and timeless appeal.', 'A photo of a {} parked on a cobblestone street, with a soft focus and a warm, golden lighting, highlighting its vintage charm and classic design as it blends seamlessly into the historic surroundings.', 'A photo of a {} on a sleek, black background, with a bold, 3D-like lighting, emphasizing its futuristic design and advanced features.'], 
    'UCF101': ['"A meticulously crafted sequence of coordinated movements, emphasizing the subtle variations in tempo, posture, and gesture that define the {}, is expertly demonstrated as a person executes the', 'A captivating spectacle of human movement unfolds as a person demonstrates the intricate nuances and techniques required to execute the {}, showcasing the distinctive physical attributes,', 'A masterclass in human physicality and technique is showcased as a person executes the {}, highlighting the distinct bodily attributes, synchronized movements, and intentional actions that define the action'], 
    'FGVCAircraft': ['A photograph of a {} aircraft from a low-angle perspective, showcasing its distinctive <shape> or <pattern> against a clear and textured background, with a prominent <detail> or <', 'A photograph of a {} aircraft with its characteristic lines, shapes, and patterns clearly visible, taken from a dynamic angle that conveys a sense of motion, texture, and depth, with a notable <detail> or <', 'A photograph of a {} aircraft with a unique <shape> or <pattern> prominently displayed, taken from a dynamic angle that conveys a sense of motion, texture, and depth, with a notable <detail> or'], 
    'Food101': ['"A {} dish served in a rustic, earthy bowl, garnished with fresh herbs and a drizzle of artisanal sauce, evoking the warmth and comfort of a home-cooked meal."', '"A skillfully composed shot of {} on a rustic wooden surface, adorned with a sprinkle of fresh herbs and a drizzle of warm sauce, evoking the cozy ambiance of a family dinner', '"A warm and inviting image of a tenderly prepared {}, served with a side of crispy, golden-brown toast and a dollop of creamy condiment, evoking the cozy atmosphere of a family dinner gathering."'], 
    'OxfordFlowers': ["A photograph of a {} in its prime, with the delicate petals and intricate details unfolding like a miniature landscape, inviting us to step into the flower's intimate world and appreciate its unique textures", "A photograph of a {} with its intricate details and subtle colors unfolding like a delicate canvas, inviting us to appreciate the flower's unique textures and the masterful arrangement of its petals and sepals as a work of art.", "A photograph of a {} in its prime, with the soft focus and blurred background emphasizing its intricate patterns, delicate petals, and subtle colors, inviting us to appreciate the flower's unique essence"], 
    'DescribableTextures': ["A photo of a {} that your hands would ache to hold, as if the tactile sensation of its texture would seep into your pores, lingering long after you've let it go.", 'A photo of a {} that your eyes trace with reverence, as if mapping the intricate landscape of its texture, and your fingertips hum with anticipation to explore its tactile secrets.', 'A photo of a {} that unfolds like a sensory tapestry, weaving together tactile whispers, visual nuances, and the promise of discovery.'],
    'Caltech101':['"A thoughtfully composed, mid-angle shot of a {} nestled among other objects on a cluttered surface, highlighting its subtle interactions with its environment while inviting the viewer to appreciate its unique textures, proportions, and intricate details."', '"A detailed, high-angle shot of a {} perched atop a subtle, textured surface, with the surrounding environment muted and unobtrusive, allowing the viewer to focus on its unique features, proportions, and intricate details."', '"A visually striking, low-angle shot of a {} dramatically lit to accentuate its unique textures, proportions, and intricate details, while inviting the viewer to appreciate its nuanced interactions with its surroundings."']
    }
