# Complete Optimization Problem and Solution: allergy_1

## 1. Problem Context and Goals

### Context  
A university is tasked with providing allergy accommodations to its students across various cities. The goal is to ensure that all students with allergies receive the necessary support while minimizing the total cost of these accommodations. The cost of providing accommodations varies depending on the type of allergy and the city where the student resides. The university has a fixed budget allocated for this purpose, and there is a minimum requirement for the amount of resources that must be allocated to each allergy type in each city. 

The decision variables in this problem represent the amount of resources allocated to students based on their allergy type and city. These resources are continuous, meaning they can take any value within the allowed range. The operational parameters include the cost of providing accommodations for each allergy type in each city, the total budget available, and the minimum required resources for each allergy type in each city. These parameters are used to ensure that the solution is both cost-effective and meets the necessary support requirements.

The business configuration includes a total budget of 500,000 units, which serves as the upper limit for the total resources allocated. Additionally, there is a minimum requirement of 5 units of resources for each allergy type in each city, ensuring that all students receive at least the necessary support. These constraints are designed to align with the linear nature of the optimization problem, avoiding any nonlinear relationships such as variable products or divisions.

### Goals  
The primary goal of this optimization problem is to minimize the total cost of providing allergy accommodations to students. This is achieved by determining the optimal allocation of resources for each allergy type in each city, ensuring that the total cost is as low as possible while still meeting the minimum resource requirements and staying within the budget. 

Success is measured by the ability to provide the necessary support to all students with allergies at the lowest possible cost. The cost of accommodations for each allergy type in each city serves as the key metric in this optimization, guiding the allocation of resources to achieve the most cost-effective solution. The goal is to ensure that the university can meet its obligations to students without exceeding its financial constraints.

## 2. Constraints    

The optimization problem is subject to two main constraints, both of which are linear in nature:

1. **Budget Constraint**: The total amount of resources allocated across all allergy types and cities must not exceed the total budget available for allergy accommodations. This ensures that the university does not overspend on providing support to students.

2. **Minimum Resource Requirement**: For each allergy type in each city, the amount of resources allocated must be at least the minimum required level. This ensures that all students with allergies receive the necessary support, regardless of the city they reside in.

These constraints are designed to ensure that the solution is both financially feasible and meets the university's obligations to its students. They are expressed in a way that naturally leads to a linear optimization formulation, avoiding any nonlinear relationships.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for cost, budget, and required resources, and updating business configuration logic with scalar parameters and formulas.

CREATE TABLE cost (
  AllergyType STRING,
  city_code STRING,
  cost FLOAT,
  resource FLOAT
);


```

### Data Dictionary  
The **cost** table contains information about the cost of providing allergy accommodations and the resources allocated for each allergy type in each city. The columns in this table are:

- **AllergyType**: Represents the type of allergy (e.g., peanut, dairy, gluten). This is used to identify the specific allergy for which accommodations are being provided.
- **city_code**: Represents the city where the student resides (e.g., NYC, LA, CHI). This is used to identify the location where the accommodations are needed.
- **cost**: Represents the cost of providing accommodations for the specific allergy type in the city. This value is used as a coefficient in the objective function to calculate the total cost.
- **resource**: Represents the amount of resources allocated to the specific allergy type in the city. This is the decision variable in the optimization problem, determining how much support is provided.


### Retrieved Values

**Query 1: This data is crucial for the objective function (minimizing total cost) and for determining the decision variables (resource allocation).**

```sql
SELECT AllergyType, city_code, cost, resource FROM cost;
```

**Results (CSV format):**
```csv
AllergyType,city_code,cost,resource
peanut,NYC,120.0,12.0
dairy,LA,100.0,10.0
gluten,CHI,90.0,9.0
```

**Query 2: This helps in understanding the current expenditure and ensuring it stays within the budget constraint.**

```sql
SELECT SUM(cost * resource) AS total_cost FROM cost;
```

**Results (CSV format):**
```csv
total_cost
3250.0
```

**Query 3: Note: Since the minimum required resources are not explicitly stored in the database, this query assumes a constant value of 5 units as per the problem description.**

```sql
SELECT AllergyType, city_code, 5 AS min_resource FROM cost;
```

**Results (CSV format):**
```csv
AllergyType,city_code,min_resource
peanut,NYC,5
dairy,LA,5
gluten,CHI,5
```

**Query 4: Note: Since the budget is not stored in the database, this query assumes a constant value of 500,000 units as per the problem description.**

```sql
SELECT 500000 AS total_budget;
```

**Results (CSV format):**
```csv
total_budget
500000
```

**Query 5: This helps in understanding the distribution of resources and ensuring that the minimum requirements are met.**

```sql
SELECT AllergyType, SUM(resource) AS total_resource FROM cost GROUP BY AllergyType;
```

**Results (CSV format):**
```csv
AllergyType,total_resource
dairy,10.0
gluten,9.0
peanut,12.0
```

**Query 6: This helps in understanding the distribution of resources across different cities.**

```sql
SELECT city_code, SUM(resource) AS total_resource FROM cost GROUP BY city_code;
```

**Results (CSV format):**
```csv
city_code,total_resource
CHI,9.0
LA,10.0
NYC,12.0
```

**Query 7: This data is useful for understanding the cost efficiency of resource allocation in different cities.**

```sql
SELECT AllergyType, city_code, cost / resource AS cost_per_unit FROM cost WHERE resource > 0;
```

**Results (CSV format):**
```csv
AllergyType,city_code,cost_per_unit
peanut,NYC,10.0
dairy,LA,10.0
gluten,CHI,10.0
```

**Query 8: This helps in identifying areas where cost optimization can be most impactful.**

```sql
SELECT city_code, AllergyType, MAX(cost / resource) AS max_cost_per_unit FROM cost WHERE resource > 0 GROUP BY city_code, AllergyType;
```

**Results (CSV format):**
```csv
city_code,AllergyType,max_cost_per_unit
CHI,gluten,10.0
LA,dairy,10.0
NYC,peanut,10.0
```

**Query 9: This helps in understanding the cost distribution across different cities.**

```sql
SELECT city_code, SUM(cost * resource) AS total_cost FROM cost GROUP BY city_code;
```

**Results (CSV format):**
```csv
city_code,total_cost
CHI,810.0
LA,1000.0
NYC,1440.0
```

**Query 10: This helps in understanding the cost distribution across different allergy types.**

```sql
SELECT AllergyType, SUM(cost * resource) AS total_cost FROM cost GROUP BY AllergyType;
```

**Results (CSV format):**
```csv
AllergyType,total_cost
dairy,1000.0
gluten,810.0
peanut,1440.0
```

