# Complete Optimization Problem and Solution: county_public_safety

## 1. Problem Context and Goals

### Context  
The optimization problem focuses on allocating police officers across multiple counties to minimize the overall crime rate while adhering to operational and resource constraints. The key decision involves determining the number of police officers assigned to each county, which must be an integer value. The crime rate in each county serves as a critical factor in this decision, as it directly influences the effectiveness of police presence. 

The total number of police officers available for allocation is limited, ensuring that the solution remains within budget and resource capacity. Additionally, each county has specific requirements for the minimum and maximum number of police officers allowed, based on local needs and operational capacity. Furthermore, the case burden per officer is constrained to ensure that officers are not overburdened, with a maximum case burden defined for each county. These constraints ensure that the allocation is both feasible and sustainable.

The business configuration includes two key parameters: the total number of police officers available for allocation and the maximum case burden per officer in each county. These parameters are critical for defining the boundaries of the optimization problem and ensuring that the solution aligns with operational realities.

### Goals  
The primary goal of this optimization is to minimize the total crime rate across all counties by strategically allocating police officers. This is achieved by reducing the product of the crime rate and the number of police officers in each county. Success is measured by the overall reduction in crime rate, which is directly influenced by the allocation of police officers. The optimization ensures that the allocation respects all operational constraints, including the total number of police officers available, the minimum and maximum police officers per county, and the maximum case burden per officer.

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Total Police Officers Constraint**: The sum of police officers allocated across all counties must not exceed the total number of police officers available.  
2. **Minimum Police Officers Constraint**: Each county must have at least the minimum number of police officers required to maintain public safety.  
3. **Maximum Police Officers Constraint**: Each county cannot exceed the maximum number of police officers allowed, based on local operational capacity.  
4. **Case Burden Constraint**: The number of police officers in each county must be sufficient to handle the population, ensuring that the case burden per officer does not exceed the defined maximum.  

These constraints ensure that the allocation of police officers is both feasible and aligned with operational requirements.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization requirements and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE county_public_safety (
  County_ID INTEGER,
  Crime_rate FLOAT,
  Police_officers INTEGER,
  Population INTEGER
);

CREATE TABLE county_police_limits (
  County_ID INTEGER,
  Minimum_Police_Officers INTEGER,
  Maximum_Police_Officers INTEGER
);
```

### Data Dictionary  
- **county_public_safety**:  
  - **County_ID**: Unique identifier for the county, used to index decision variables and constraints.  
  - **Crime_rate**: The crime rate in the county, serving as the coefficient in the objective function.  
  - **Police_officers**: The number of police officers in the county, which is the decision variable to be optimized.  
  - **Population**: The population of the county, used to define the case burden constraint.  

- **county_police_limits**:  
  - **County_ID**: Unique identifier for the county, used to index constraints.  
  - **Minimum_Police_Officers**: The minimum number of police officers required in the county, defining a lower bound for the decision variable.  
  - **Maximum_Police_Officers**: The maximum number of police officers allowed in the county, defining an upper bound for the decision variable.  


### Retrieved Values

**Query 1: This data is crucial for determining the effectiveness of police presence and ensuring that the case burden constraint is respected.**

```sql
SELECT County_ID, Crime_rate, Population FROM county_public_safety;
```

**Results (CSV format):**
```csv
County_ID,Crime_rate,Population
1,0.05,10000
2,0.1,20000
3,0.15,30000
```

**Query 2: This data ensures that the allocation of police officers respects the operational capacity of each county.**

```sql
SELECT County_ID, Minimum_Police_Officers, Maximum_Police_Officers FROM county_police_limits;
```

**Results (CSV format):**
```csv
County_ID,Minimum_Police_Officers,Maximum_Police_Officers
1,10,100
2,20,200
3,30,300
```

**Query 3: This data is necessary for understanding the current allocation and for comparing it with the optimized allocation.**

```sql
SELECT County_ID, Police_officers FROM county_public_safety;
```

**Results (CSV format):**
```csv
County_ID,Police_officers
1,50
2,100
3,150
```

**Query 4: This data helps in verifying that the sum of allocated police officers does not exceed the total available.**

```sql
SELECT SUM(Police_officers) AS Total_Police_Officers FROM county_public_safety;
```

**Results (CSV format):**
```csv
Total_Police_Officers
300
```

**Query 5: This combined data is essential for calculating the case burden, ensuring constraints are met, and optimizing the allocation.**

```sql
SELECT cps.County_ID, cps.Crime_rate, cps.Population, cps.Police_officers, cpl.Minimum_Police_Officers, cpl.Maximum_Police_Officers FROM county_public_safety cps JOIN county_police_limits cpl ON cps.County_ID = cpl.County_ID;
```

**Results (CSV format):**
```csv
County_ID,Crime_rate,Population,Police_officers,Minimum_Police_Officers,Maximum_Police_Officers
1,0.05,10000,50,10,100
2,0.1,20000,100,20,200
3,0.15,30000,150,30,300
```

**Query 6: This data is crucial for ensuring that the case burden constraint is respected and that officers are not overburdened.**

```sql
SELECT County_ID, Population / Police_officers AS Case_Burden_Per_Officer FROM county_public_safety WHERE Police_officers > 0;
```

**Results (CSV format):**
```csv
County_ID,Case_Burden_Per_Officer
1,200
2,200
3,200
```

**Query 7: This data provides context for the scale of the problem and the potential impact of the optimization.**

```sql
SELECT SUM(Population) AS Total_Population FROM county_public_safety;
```

**Results (CSV format):**
```csv
Total_Population
60000
```

**Query 8: This data helps identify counties that may need immediate attention in the optimization process.**

```sql
SELECT cps.County_ID, cps.Police_officers, cpl.Minimum_Police_Officers FROM county_public_safety cps JOIN county_police_limits cpl ON cps.County_ID = cpl.County_ID WHERE cps.Police_officers < cpl.Minimum_Police_Officers;
```

**Results (CSV format):**
```csv
County_ID,Police_officers,Minimum_Police_Officers
```

**Query 9: This data helps identify counties where resources may be reallocated to other areas in need.**

```sql
SELECT cps.County_ID, cps.Police_officers, cpl.Maximum_Police_Officers FROM county_public_safety cps JOIN county_police_limits cpl ON cps.County_ID = cpl.County_ID WHERE cps.Police_officers > cpl.Maximum_Police_Officers;
```

**Results (CSV format):**
```csv
County_ID,Police_officers,Maximum_Police_Officers
```

**Query 10: This data helps identify counties where additional police officers may be needed to reduce the case burden.**

```sql
SELECT County_ID, Population / Police_officers AS Case_Burden_Per_Officer FROM county_public_safety WHERE Police_officers > 0 AND Population / Police_officers > [Predefined_Threshold];
```

**Error:** Execution failed on sql 'SELECT County_ID, Population / Police_officers AS Case_Burden_Per_Officer FROM county_public_safety WHERE Police_officers > 0 AND Population / Police_officers > [Predefined_Threshold];': no such column: Predefined_Threshold

