# Complete Optimization Problem and Solution: culture_company

## 1. Problem Context and Goals

### Context  
The culture company is focused on maximizing its annual profit by strategically allocating its resources between two key areas: book clubs and movie productions. The company has a total budget of $1,000,000 available for investments in these areas. Each investment category has specific operational parameters that must be adhered to. For book clubs, the company must invest at least $100,000 but no more than $500,000. Similarly, for movies, the minimum investment is $150,000, with a maximum cap of $600,000. Additionally, the company has set a minimum total profit target of $200,000 to ensure financial sustainability.

The expected profit per unit investment is $0.15 for book clubs and $0.20 for movies. These profit rates are based on historical data and industry standards, ensuring realistic and achievable targets. The company’s goal is to determine the optimal amount to invest in each category to maximize total profit while staying within the defined budget and investment limits.

### Goals  
The primary goal of this optimization problem is to maximize the company’s total annual profit by determining the best allocation of investments between book clubs and movies. Success is measured by achieving the highest possible profit, calculated as the sum of the expected profit from book clubs and movies, while ensuring all operational constraints are met. The company aims to make data-driven decisions that align with its financial goals and resource limitations.

## 2. Constraints    

The company must adhere to several constraints to ensure a balanced and feasible investment strategy:

1. **Budget Constraint**: The total investment in both book clubs and movies must not exceed the available budget of $1,000,000.
2. **Minimum Investment in Book Clubs**: The company must invest at least $100,000 in book clubs to maintain operations.
3. **Minimum Investment in Movies**: A minimum investment of $150,000 is required in movies to cover production costs.
4. **Maximum Investment in Book Clubs**: The investment in book clubs cannot exceed $500,000 to prevent over-allocation of resources.
5. **Maximum Investment in Movies**: The investment in movies is capped at $600,000 to ensure diversification of resources.
6. **Minimum Total Profit**: The combined profit from both book clubs and movies must be at least $200,000 to meet the company’s financial sustainability target.

These constraints ensure that the company’s investment strategy is both realistic and aligned with its operational and financial goals.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes and configuration logic updates implemented to address missing optimization requirements and mapping gaps identified by the OR expert.

CREATE TABLE investment_profits (
  profit_book_club FLOAT,
  profit_movie FLOAT,
  x_book_club FLOAT,
  x_movie FLOAT
);
```

### Data Dictionary  
The `investment_profits` table contains the following columns, each with a specific business purpose and optimization role:

- **profit_book_club**: Represents the expected profit per unit investment in book clubs. This value is used as the objective coefficient for book club investments in the optimization problem.
- **profit_movie**: Represents the expected profit per unit investment in movies. This value is used as the objective coefficient for movie investments in the optimization problem.
- **x_book_club**: Represents the decision variable for the amount to invest in book clubs. This is a continuous variable that can take any value within the defined investment limits.
- **x_movie**: Represents the decision variable for the amount to invest in movies. This is a continuous variable that can take any value within the defined investment limits.


### Retrieved Values

**Query 1: This data is crucial for the objective function coefficients in the optimization problem.**

```sql
SELECT profit_book_club, profit_movie FROM investment_profits;
```

**Results (CSV format):**
```csv
profit_book_club,profit_movie
0.15,0.2
0.18,0.22
0.12,0.18
```

**Query 2: These are the decision variables that need to be optimized.**

```sql
SELECT x_book_club, x_movie FROM investment_profits;
```

**Results (CSV format):**
```csv
x_book_club,x_movie
200000.0,300000.0
250000.0,350000.0
150000.0,250000.0
```

**Query 3: This is important to ensure the budget constraint is not exceeded.**

```sql
SELECT x_book_club + x_movie AS total_investment FROM investment_profits;
```

**Results (CSV format):**
```csv
total_investment
500000.0
600000.0
400000.0
```

**Query 4: This is important to ensure the minimum total profit constraint is met.**

```sql
SELECT (x_book_club * profit_book_club) + (x_movie * profit_movie) AS total_profit FROM investment_profits;
```

**Results (CSV format):**
```csv
total_profit
90000.0
122000.0
63000.0
```

**Query 5: This is important to ensure the investment in book clubs is within the defined limits.**

```sql
SELECT x_book_club FROM investment_profits WHERE x_book_club BETWEEN 100000 AND 500000;
```

**Results (CSV format):**
```csv
x_book_club
200000.0
250000.0
150000.0
```

**Query 6: This is important to ensure the investment in movies is within the defined limits.**

```sql
SELECT x_movie FROM investment_profits WHERE x_movie BETWEEN 150000 AND 600000;
```

**Results (CSV format):**
```csv
x_movie
300000.0
350000.0
250000.0
```

**Query 7: This is important to ensure the overall financial sustainability of the company.**

```sql
SELECT x_book_club + x_movie AS total_investment, (x_book_club * profit_book_club) + (x_movie * profit_movie) AS total_profit FROM investment_profits WHERE x_book_club + x_movie <= 1000000 AND (x_book_club * profit_book_club) + (x_movie * profit_movie) >= 200000;
```

**Results (CSV format):**
```csv
total_investment,total_profit
```

