# Complete Optimization Problem and Solution: flight_company

## 1. Problem Context and Goals

### Context  
The flight scheduling optimization problem focuses on minimizing total fuel consumption across all flights by assigning each flight to an airport and a company. The decision involves determining whether a specific flight is assigned to a particular airport and company, represented as a binary decision variable. The fuel consumption for each flight is calculated using a predefined coefficient that reflects the fuel efficiency of the flight under specific operational conditions.  

Operational constraints include ensuring that each flight is assigned to exactly one airport and one company, respecting the capacity limits of both airports and companies. Additionally, flights must operate within predefined velocity and altitude ranges to ensure safety and efficiency. The minimum and maximum velocity constraints are set to balance speed and fuel consumption, while the altitude constraints ensure flights operate within safe and efficient airspace levels.  

The fuel consumption calculation is based on a linear relationship between the fuel consumption coefficient and the distance traveled, ensuring the objective function remains linear. This approach avoids nonlinear relationships, such as variable products or divisions, which would complicate the optimization process.  

### Goals  
The primary goal of this optimization problem is to minimize the total fuel consumption across all flights. This is achieved by optimizing the assignment of flights to airports and companies, ensuring that each flight is assigned to exactly one airport and one company while respecting operational constraints.  

Success is measured by the reduction in total fuel consumption, which is directly influenced by the fuel consumption coefficients and the assignment decisions. The optimization process ensures that the fuel consumption coefficients are used effectively to achieve the lowest possible fuel consumption while maintaining operational feasibility.  

## 2. Constraints  

The optimization problem is subject to the following constraints:  

1. **Flight Assignment Constraint**: Each flight must be assigned to exactly one airport and one company. This ensures that all flights are scheduled and no flight is left unassigned.  

2. **Airport Capacity Constraint**: The total number of flights assigned to an airport cannot exceed the airport's capacity. This ensures that airports are not overloaded and can handle the assigned flights efficiently.  

3. **Company Capacity Constraint**: The total number of flights assigned to a company cannot exceed the company's capacity. This ensures that companies can manage the assigned flights without exceeding their operational limits.  

4. **Velocity Constraint**: Each flight must operate within its predefined minimum and maximum velocity limits. This ensures that flights maintain safe and efficient speeds, balancing fuel consumption and travel time.  

5. **Altitude Constraint**: Each flight must operate within its predefined minimum and maximum altitude limits. This ensures that flights operate within safe and efficient airspace levels, avoiding conflicts with other air traffic and optimizing fuel efficiency.  

These constraints are designed to ensure that the optimization problem remains linear and feasible, avoiding any nonlinear relationships that could complicate the solution process.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Schema changes include creating a table for flight assignments to address the missing decision variable. Configuration logic updates include scalar parameters for velocity and altitude constraints and formulas for fuel consumption calculations.

CREATE TABLE fuel_consumption_coefficients (
  flight_id INTEGER,
  coefficient FLOAT
);

CREATE TABLE velocity_constraints (
  flight_id INTEGER,
  velocity_min INTEGER,
  velocity_max INTEGER
);

CREATE TABLE altitude_constraints (
  flight_id INTEGER,
  altitude_min INTEGER,
  altitude_max INTEGER
);

CREATE TABLE airport_capacities (
  airport_id INTEGER,
  capacity INTEGER
);

CREATE TABLE company_capacities (
  company_id INTEGER,
  capacity INTEGER
);

CREATE TABLE flight_assignments (
  flight_id INTEGER,
  airport_id INTEGER,
  company_id INTEGER,
  assignment BOOLEAN
);
```

### Data Dictionary  
- **fuel_consumption_coefficients**: Contains the fuel consumption coefficients for each flight, which are used to calculate the total fuel consumption in the objective function.  
  - *flight_id*: Unique identifier for each flight.  
  - *coefficient*: Fuel consumption coefficient for the flight, used in the objective function.  

- **velocity_constraints**: Defines the minimum and maximum velocity constraints for each flight, ensuring flights operate within safe and efficient speed limits.  
  - *flight_id*: Unique identifier for each flight.  
  - *velocity_min*: Minimum velocity constraint for the flight.  
  - *velocity_max*: Maximum velocity constraint for the flight.  

- **altitude_constraints**: Defines the minimum and maximum altitude constraints for each flight, ensuring flights operate within safe and efficient airspace levels.  
  - *flight_id*: Unique identifier for each flight.  
  - *altitude_min*: Minimum altitude constraint for the flight.  
  - *altitude_max*: Maximum altitude constraint for the flight.  

- **airport_capacities**: Specifies the maximum number of flights each airport can handle, ensuring airports are not overloaded.  
  - *airport_id*: Unique identifier for each airport.  
  - *capacity*: Maximum number of flights the airport can handle.  

- **company_capacities**: Specifies the maximum number of flights each company can handle, ensuring companies can manage their assigned flights.  
  - *company_id*: Unique identifier for each company.  
  - *capacity*: Maximum number of flights the company can handle.  

- **flight_assignments**: Represents the binary decision variable indicating whether a flight is assigned to an airport and a company.  
  - *flight_id*: Unique identifier for each flight.  
  - *airport_id*: Unique identifier for each airport.  
  - *company_id*: Unique identifier for each company.  
  - *assignment*: Binary variable indicating if the flight is assigned to the airport and company.  


### Retrieved Values

**Query 1: This is crucial for the objective function, as it provides the data needed to calculate total fuel consumption.**

```sql
SELECT fa.flight_id, fa.airport_id, fa.company_id, fa.assignment, fcc.coefficient FROM flight_assignments fa JOIN fuel_consumption_coefficients fcc ON fa.flight_id = fcc.flight_id WHERE fa.assignment = TRUE;
```

**Results (CSV format):**
```csv
flight_id,airport_id,company_id,assignment,coefficient
1,1,1,1,0.5
2,2,2,1,0.6
3,3,3,1,0.7
```

**Query 2: This is important for ensuring that flights operate within safe and efficient speed limits.**

```sql
SELECT flight_id, velocity_min, velocity_max FROM velocity_constraints;
```

**Results (CSV format):**
```csv
flight_id,velocity_min,velocity_max
1,500,900
2,550,950
3,600,1000
```

**Query 3: This is important for ensuring that flights operate within safe and efficient airspace levels.**

```sql
SELECT flight_id, altitude_min, altitude_max FROM altitude_constraints;
```

**Results (CSV format):**
```csv
flight_id,altitude_min,altitude_max
1,30000,40000
2,31000,41000
3,32000,42000
```

**Query 4: This is necessary to ensure that the number of flights assigned to each airport does not exceed its capacity.**

```sql
SELECT airport_id, capacity FROM airport_capacities;
```

**Results (CSV format):**
```csv
airport_id,capacity
1,10
2,15
3,20
```

**Query 5: This is necessary to ensure that the number of flights assigned to each company does not exceed its capacity.**

```sql
SELECT company_id, capacity FROM company_capacities;
```

**Results (CSV format):**
```csv
company_id,capacity
1,5
2,10
3,15
```

**Query 6: This helps in verifying the airport capacity constraint.**

```sql
SELECT airport_id, COUNT(flight_id) AS total_flights FROM flight_assignments WHERE assignment = TRUE GROUP BY airport_id;
```

**Results (CSV format):**
```csv
airport_id,total_flights
1,1
2,1
3,1
```

**Query 7: This helps in verifying the company capacity constraint.**

```sql
SELECT company_id, COUNT(flight_id) AS total_flights FROM flight_assignments WHERE assignment = TRUE GROUP BY company_id;
```

**Results (CSV format):**
```csv
company_id,total_flights
1,1
2,1
3,1
```

**Query 8: This is important for ensuring that all flights are scheduled and no flight is left unassigned.**

```sql
SELECT flight_id FROM flight_assignments WHERE assignment = FALSE;
```

**Results (CSV format):**
```csv
flight_id
```

**Query 9: This is essential for the objective function, as it provides the coefficients needed to calculate total fuel consumption.**

```sql
SELECT flight_id, coefficient FROM fuel_consumption_coefficients;
```

**Results (CSV format):**
```csv
flight_id,coefficient
1,0.5
2,0.6
3,0.7
```

**Query 10: This is useful for ensuring that flights operate within their predefined velocity and altitude limits.**

```sql
SELECT fa.flight_id, fa.airport_id, fa.company_id, fa.assignment, vc.velocity_min, vc.velocity_max, ac.altitude_min, ac.altitude_max FROM flight_assignments fa JOIN velocity_constraints vc ON fa.flight_id = vc.flight_id JOIN altitude_constraints ac ON fa.flight_id = ac.flight_id WHERE fa.assignment = TRUE;
```

**Results (CSV format):**
```csv
flight_id,airport_id,company_id,assignment,velocity_min,velocity_max,altitude_min,altitude_max
1,1,1,1,500,900,30000,40000
2,2,2,1,550,950,31000,41000
3,3,3,1,600,1000,32000,42000
```

