# Complete Optimization Problem and Solution: game_injury

## 1. Problem Context and Goals

### Context  
A sports league is focused on reducing the total number of injuries across all scheduled games while ensuring that stadiums operate within their capacity limits and maintain a minimum average attendance. The league must make decisions on which games to schedule, represented by binary decision variables, and manage the usage percentage of each stadium, represented by continuous decision variables. The injury risk for each game is calculated based on historical data, specifically the ratio of historical injuries to the total number of games played. This risk value is used as a coefficient in the optimization objective.  

The league operates under specific business configurations:  
- **Maximum capacity percentage for each stadium**: Each stadium has a predefined maximum capacity percentage, ensuring that usage does not exceed safe operational limits.  
- **Minimum average attendance required for each stadium**: To meet financial and operational goals, each stadium must maintain a minimum average attendance level.  

These configurations ensure that the optimization problem remains linear, avoiding complex nonlinear relationships such as variable products or divisions. The operational parameters and business logic are designed to align with a linear optimization formulation, focusing on minimizing injury risk while adhering to capacity and attendance constraints.

### Goals  
The primary goal of the optimization is to minimize the total injury risk across all scheduled games. This is achieved by summing the injury risk for each game multiplied by the decision to schedule that game. Success is measured by achieving the lowest possible total injury risk while ensuring that all stadiums operate within their capacity limits and meet the minimum average attendance requirements. The optimization process uses realistic business data and configurations to ensure that the results are both mathematically consistent and operationally feasible.

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Stadium Capacity Constraint**: The total usage of each stadium, calculated as the sum of scheduled games multiplied by the stadium's capacity percentage, must not exceed the stadium's maximum capacity percentage. This ensures that stadiums operate within safe and manageable limits.  
2. **Minimum Attendance Constraint**: The total attendance across all scheduled games for each stadium must meet or exceed the minimum average attendance requirement. This ensures that financial and operational goals are met while maintaining fan engagement.  

These constraints are designed to align with linear mathematical forms, avoiding any nonlinear relationships such as variable products or divisions. They ensure that the optimization problem remains tractable and aligned with the league's operational requirements.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for injury risk, game scheduling, and stadium usage. Configuration logic updates include scalar parameters for stadium capacity and minimum average attendance, and formulas for injury risk calculation.

CREATE TABLE injury_risk (
  game_id INTEGER,
  risk_value FLOAT
);

CREATE TABLE game_scheduling (
  game_id INTEGER,
  is_scheduled BOOLEAN
);

CREATE TABLE stadium_usage (
  stadium_id INTEGER,
  usage_percentage FLOAT
);

CREATE TABLE stadium (
  stadium_id INTEGER,
  capacity_percentage FLOAT,
  average_attendance INTEGER
);
```

### Data Dictionary  
- **Injury Risk Table**:  
  - **Purpose**: Stores the risk of injury for each game, calculated based on historical data.  
  - **Optimization Role**: Provides coefficients for the objective function, representing the injury risk for each game.  

- **Game Scheduling Table**:  
  - **Purpose**: Stores decisions on whether each game is scheduled.  
  - **Optimization Role**: Represents binary decision variables in the optimization problem.  

- **Stadium Usage Table**:  
  - **Purpose**: Tracks the percentage of capacity used for each stadium.  
  - **Optimization Role**: Represents continuous decision variables in the optimization problem.  

- **Stadium Table**:  
  - **Purpose**: Stores capacity and attendance data for each stadium.  
  - **Optimization Role**: Provides constraint bounds for stadium capacity and minimum average attendance.  


### Retrieved Values

**Query 1: Query Description: Retrieve the injury risk values for all games. This data is crucial for the objective function coefficients in the optimization problem, as it represents the injury risk for each game.**

```sql
SELECT game_id, risk_value FROM injury_risk;
```

**Results (CSV format):**
```csv
game_id,risk_value
1,0.15
2,0.1
3,0.2
```

**Query 2: Query Description: Retrieve the scheduling decisions for all games. This data represents the binary decision variables in the optimization problem, indicating whether each game is scheduled or not.**

```sql
SELECT game_id, is_scheduled FROM game_scheduling;
```

**Results (CSV format):**
```csv
game_id,is_scheduled
1,1
2,0
3,1
```

**Query 3: Query Description: Retrieve the usage percentage for each stadium. This data represents the continuous decision variables in the optimization problem, indicating the percentage of capacity used for each stadium.**

```sql
SELECT stadium_id, usage_percentage FROM stadium_usage;
```

**Results (CSV format):**
```csv
stadium_id,usage_percentage
1,0.75
2,0.8
3,0.7
```

**Query 4: Query Description: Retrieve the capacity percentage and minimum average attendance for each stadium. This data provides the constraint bounds for stadium capacity and minimum average attendance, ensuring that the optimization problem adheres to operational limits.**

```sql
SELECT stadium_id, capacity_percentage, average_attendance FROM stadium;
```

**Results (CSV format):**
```csv
stadium_id,capacity_percentage,average_attendance
1,0.85,5500
2,0.9,6000
3,0.8,5000
```

**Query 5: Query Description: Retrieve the total usage percentage for each stadium, aggregated from the stadium_usage table. This data is important for the stadium capacity constraint, ensuring that the total usage does not exceed the maximum capacity percentage.**

```sql
SELECT stadium_id, SUM(usage_percentage) AS total_usage_percentage FROM stadium_usage GROUP BY stadium_id;
```

**Results (CSV format):**
```csv
stadium_id,total_usage_percentage
1,0.75
2,0.8
3,0.7
```

**Query 6: Query Description: Retrieve the total attendance for each stadium, calculated by summing the average attendance for all scheduled games. This data is important for the minimum attendance constraint, ensuring that the total attendance meets or exceeds the minimum average attendance requirement.**

```sql
SELECT s.stadium_id, SUM(s.average_attendance) AS total_attendance FROM stadium s JOIN game_scheduling gs ON s.stadium_id = gs.game_id WHERE gs.is_scheduled = TRUE GROUP BY s.stadium_id;
```

**Results (CSV format):**
```csv
stadium_id,total_attendance
1,5500
3,5000
```

**Query 7: Query Description: Retrieve the injury risk values for scheduled games only. This data is useful for calculating the total injury risk in the objective function, considering only the games that are actually scheduled.**

```sql
SELECT ir.game_id, ir.risk_value FROM injury_risk ir JOIN game_scheduling gs ON ir.game_id = gs.game_id WHERE gs.is_scheduled = TRUE;
```

**Results (CSV format):**
```csv
game_id,risk_value
1,0.15
3,0.2
```

**Query 8: Query Description: Retrieve the maximum capacity percentage for each stadium. This data is crucial for the stadium capacity constraint, ensuring that the total usage does not exceed the maximum capacity percentage.**

```sql
SELECT stadium_id, capacity_percentage FROM stadium;
```

**Results (CSV format):**
```csv
stadium_id,capacity_percentage
1,0.85
2,0.9
3,0.8
```

**Query 9: Query Description: Retrieve the minimum average attendance for each stadium. This data is crucial for the minimum attendance constraint, ensuring that the total attendance meets or exceeds the minimum average attendance requirement.**

```sql
SELECT stadium_id, average_attendance FROM stadium;
```

**Results (CSV format):**
```csv
stadium_id,average_attendance
1,5500
2,6000
3,5000
```

**Query 10: Query Description: Retrieve the total injury risk for all scheduled games. This data is useful for evaluating the objective function, providing a summary of the total injury risk across all scheduled games.**

```sql
SELECT SUM(ir.risk_value) AS total_injury_risk FROM injury_risk ir JOIN game_scheduling gs ON ir.game_id = gs.game_id WHERE gs.is_scheduled = TRUE;
```

**Results (CSV format):**
```csv
total_injury_risk
0.35
```

